/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.custom.InstabilityStabilizerBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ScrubberBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType EIDOLON_THRESHER_PART = AbyssTechRenderHelper.renderTypeRegisterSolid("eidolon_thresher_part_render", "textures/render/eidolon_thresher_part.png");

    public ScrubberBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(EIDOLON_THRESHER_PART));
    }

    private void renderCube(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        if (level != null && level.getBlockState(blockEntity.getBlockPos().above(1)).is(AbyssTechBlocks.EIDOLON_THRESHER) && (blockEntity2 = level.getBlockEntity(blockEntity.getBlockPos())) instanceof InstabilityStabilizerBlockEntity) {
            InstabilityStabilizerBlockEntity scrubber = (InstabilityStabilizerBlockEntity)blockEntity2;
            float scaleOne = 0.35f;
            float scaleTwo = 0.65f;
            float yPosTranslation = scrubber.getAnimatePartYPos();
            float distScale = 0.9f;
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleTwo + yPosTranslation + distScale, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation + distScale, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation + distScale, scaleOne + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwo + yPosTranslation + distScale, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation + distScale, scaleTwo + yPosTranslation + distScale, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer vertexConsumer, float xStart, float xEnd, float yStart, float yEnd, float z1, float z2, float z3, float z4, Direction direction) {
        int skyLight = 15;
        int light = 0xF000F0;
        vertexConsumer.addVertex(matrix, xStart, yStart, z1).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yStart, z2).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yEnd, z3).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xStart, yEnd, z4).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
    }
}

