/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.SingleItemContainer;
import net.quasar.abysstech.block.entity.custom.SingleItemContainerBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;

public class SingleItemContainerBlockEntityRenderer
implements BlockEntityRenderer<SingleItemContainerBlockEntity> {
    public SingleItemContainerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SingleItemContainerBlockEntity singleItemContainerBlockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        if (singleItemContainerBlockEntity.getLevel() != null) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            ItemStack stack = singleItemContainerBlockEntity.getItem(0);
            BlockState state = singleItemContainerBlockEntity.getBlockState();
            if (((Boolean)state.getValue((Property)SingleItemContainer.hasItem)).booleanValue()) {
                switch (this.getBlockType(state)) {
                    case 1: {
                        for (int i = 0; i < 4; ++i) {
                            this.renderItem(poseStack, multiBufferSource, itemRenderer, singleItemContainerBlockEntity, stack, this.fourSidesTranslations(i)[0], 0.5f, this.fourSidesTranslations(i)[1], 0.4f, 0.4f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, this.fourSidesTranslations(i)[2]);
                        }
                        break;
                    }
                    case 2: {
                        this.renderItem(poseStack, multiBufferSource, itemRenderer, singleItemContainerBlockEntity, stack, 0.5f, 0.6f, 0.5f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        this.renderItem(poseStack, multiBufferSource, itemRenderer, singleItemContainerBlockEntity, stack, this.translationByFace(state)[0], 0.1f, this.translationByFace(state)[1], 0.8f, 0.8f, 0.8f, 0.0f, 0.0f, 0.0f, 0.0f, this.translationByFace(state)[2]);
                        break;
                    }
                    default: {
                        this.renderItem(poseStack, multiBufferSource, itemRenderer, singleItemContainerBlockEntity, stack, 0.5f, 1.2f + singleItemContainerBlockEntity.bobRenderedItem(), 0.5f, 0.4f, 0.4f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, singleItemContainerBlockEntity.rotateRenderedItem());
                    }
                }
            }
        }
    }

    private int getBlockType(BlockState state) {
        if (state.is(AbyssTechBlocks.MIXER_CHAMBER)) {
            return 1;
        }
        if (state.is(AbyssTechBlocks.TEAR_VAT)) {
            return 2;
        }
        if (state.is(AbyssTechBlocks.HANGING_HOOK)) {
            return 3;
        }
        return 0;
    }

    private float[] fourSidesTranslations(int i) {
        float[] fArray;
        switch (i) {
            case 0: {
                float[] fArray2 = new float[3];
                fArray2[0] = 0.5f;
                fArray2[1] = 0.0f;
                fArray = fArray2;
                fArray2[2] = 0.0f;
                break;
            }
            case 1: {
                float[] fArray3 = new float[3];
                fArray3[0] = 0.5f;
                fArray3[1] = 1.0f;
                fArray = fArray3;
                fArray3[2] = 0.0f;
                break;
            }
            case 2: {
                float[] fArray4 = new float[3];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.5f;
                fArray = fArray4;
                fArray4[2] = 90.0f;
                break;
            }
            default: {
                float[] fArray5 = new float[3];
                fArray5[0] = 1.0f;
                fArray5[1] = 0.5f;
                fArray = fArray5;
                fArray5[2] = 90.0f;
            }
        }
        return fArray;
    }

    private float[] translationByFace(BlockState state) {
        float[] toReturn = new float[]{0.5f, 0.5f, 0.0f};
        if (state.is(AbyssTechBlocks.HANGING_HOOK)) {
            Direction direction = (Direction)state.getValue((Property)SingleItemContainer.FACING);
            switch (direction) {
                case NORTH: {
                    toReturn[1] = 0.3f;
                    break;
                }
                case EAST: {
                    toReturn[2] = 90.0f;
                    toReturn[0] = 0.7f;
                    break;
                }
                case SOUTH: {
                    toReturn[1] = 0.7f;
                    break;
                }
                default: {
                    toReturn[2] = 90.0f;
                    toReturn[0] = 0.3f;
                }
            }
        }
        return toReturn;
    }

    private void renderItem(PoseStack poseStack, MultiBufferSource multiBufferSource, ItemRenderer itemRenderer, SingleItemContainerBlockEntity singleItemContainerBlockEntity, ItemStack stack, float transX, float transY, float transZ, float scaleX, float scaleY, float scaleZ, float XPd, float XPx, float XPy, float XPz, float YPd) {
        poseStack.pushPose();
        poseStack.translate(transX, transY, transZ);
        poseStack.scale(scaleX, scaleY, scaleZ);
        poseStack.rotateAround(Axis.XP.rotationDegrees(XPd), XPx, XPy, XPz);
        poseStack.mulPose(Axis.YP.rotationDegrees(YPd));
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, AbyssTechRenderHelper.getLightLevel(singleItemContainerBlockEntity.getLevel(), singleItemContainerBlockEntity.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, singleItemContainerBlockEntity.getLevel(), 1);
        poseStack.popPose();
    }
}

