/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.custom.Study;
import net.quasar.abysstech.block.entity.custom.StudyBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;

public class StudyBlockEntityRenderer
implements BlockEntityRenderer<StudyBlockEntity> {
    private final Font font;

    public StudyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(StudyBlockEntity studyBe, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        if (studyBe.getLevel() != null) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            ItemStack stack = studyBe.getItem(0);
            BlockState state = studyBe.getBlockState();
            if (((Boolean)state.getValue((Property)Study.hasItem)).booleanValue()) {
                this.renderItem(poseStack, itemRenderer, multiBufferSource, studyBe, stack, studyBe.bobRenderedItem(), studyBe.rotateRenderedItem());
                if (studyBe.getMiniGameToggle()) {
                    this.renderFloatingText(poseStack, multiBufferSource, String.valueOf(studyBe.getTargetTearValue()), 1.7f, this.getRotationFromFacing(state));
                    this.renderFloatingText(poseStack, multiBufferSource, String.valueOf(studyBe.getTearValue()), 1.9f, this.getRotationFromFacing(state));
                }
            }
        }
    }

    private float getRotationFromFacing(BlockState state) {
        return switch ((Direction)state.getValue((Property)Study.FACING)) {
            case Direction.SOUTH -> 3.15f;
            case Direction.EAST -> 4.725f;
            case Direction.WEST -> 1.575f;
            default -> 0.0f;
        };
    }

    private void renderItem(PoseStack poseStack, ItemRenderer itemRenderer, MultiBufferSource multiBufferSource, StudyBlockEntity studyBe, ItemStack stack, float bob, float rotation) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.2f + bob, 0.5f);
        poseStack.scale(0.4f, 0.4f, 0.4f);
        poseStack.rotateAround(Axis.XP.rotationDegrees(0.0f), 0.0f, 0.0f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, AbyssTechRenderHelper.getLightLevel(studyBe.getLevel(), studyBe.getBlockPos()), OverlayTexture.NO_OVERLAY, poseStack, multiBufferSource, studyBe.getLevel(), 1);
        poseStack.popPose();
    }

    private void renderFloatingText(PoseStack poseStack, MultiBufferSource bufferSource, String text, float y, float rotation) {
        poseStack.pushPose();
        poseStack.translate(0.5f, y, 0.5f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YN.rotation(rotation));
        float scale = 0.02f;
        poseStack.scale(scale, scale, scale);
        int textWidth = this.font.width(text);
        float xOffset = (float)(-textWidth) / 2.0f;
        this.font.drawInBatch((Component)Component.literal((String)text), xOffset, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
    }
}

