/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.entity.custom.TranslatorBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;

@OnlyIn(value=Dist.CLIENT)
public class TranslatorBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final Font font;
    private final int glitchChance = 640;
    private final String tGlitchText = "[][][][][][][][][][][][][][][][][][][][]";
    Random random = new Random();

    public TranslatorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.getFont();
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof TranslatorBlockEntity) {
            TranslatorBlockEntity translatorBlock = (TranslatorBlockEntity)blockEntity2;
            List<Component> displayText = AbyssTechRenderHelper.textSplitter(translatorBlock.getText(), 35);
            float ySpacing = 0.2f * (float)displayText.size();
            for (Component textLine : displayText) {
                int xGlitchChance = this.random.nextInt(640);
                int tGlitchChance = this.random.nextInt(640);
                this.renderFloatingText(poseStack, bufferSource, tGlitchChance != 1 ? textLine.getString() : this.tGlitchText, xGlitchChance != 1 ? 0.5f : 0.5f + this.random.nextFloat(0.2f) - 0.1f, 1.6f + ySpacing, 0.5f, translatorBlock.getYRotation());
                ySpacing -= 0.2f;
            }
        }
    }

    private void renderFloatingText(PoseStack poseStack, MultiBufferSource bufferSource, String text, float x, float y, float z, float rotation) {
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YN.rotation(rotation));
        float scale = 0.02f;
        poseStack.scale(scale, scale, scale);
        int textWidth = this.font.width(text);
        float xOffset = (float)(-textWidth) / 2.0f;
        this.font.drawInBatch((Component)Component.literal((String)text), xOffset, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
    }
}

