/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.quasar.abysstech.block.entity.custom.XpMachineBlockEntity;
import net.quasar.abysstech.block.entity.renderer.AbyssTechRenderHelper;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class XpMachineBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType XP_FIELD = AbyssTechRenderHelper.renderTypeRegisterGateWay("xp_field_render", "textures/render/xp_field.png");

    public XpMachineBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderCube(blockEntity, matrix4f, bufferSource.getBuffer(this.renderType()));
    }

    private void renderCube(T blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        BlockEntity blockEntity2;
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        if (level != null && (blockEntity2 = level.getBlockEntity(pos)) instanceof XpMachineBlockEntity) {
            XpMachineBlockEntity xpMachineBe = (XpMachineBlockEntity)blockEntity2;
            float scaleOne = 0.45f - (float)xpMachineBe.getXpAmount() * (0.3f / (float)xpMachineBe.getMaxXpAmount());
            float scaleTwo = 0.55f + (float)xpMachineBe.getXpAmount() * (0.3f / (float)xpMachineBe.getMaxXpAmount());
            float yPosTranslation = 0.0f;
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleTwo, scaleTwo, Direction.SOUTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleOne, scaleOne, Direction.NORTH);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleTwo, scaleTwo, scaleTwo + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.EAST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleOne, scaleOne + yPosTranslation, scaleTwo + yPosTranslation, scaleOne, scaleTwo, scaleTwo, scaleOne, Direction.WEST);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleOne + yPosTranslation, scaleOne + yPosTranslation, scaleOne, scaleOne, scaleTwo, scaleTwo, Direction.DOWN);
            this.renderFace(blockEntity, matrix4f, vertexConsumer, scaleOne, scaleTwo, scaleTwo + yPosTranslation, scaleTwo + yPosTranslation, scaleTwo, scaleTwo, scaleOne, scaleOne, Direction.UP);
        }
    }

    private void renderFace(T blockEntity, Matrix4f matrix, VertexConsumer vertexConsumer, float xStart, float xEnd, float yStart, float yEnd, float z1, float z2, float z3, float z4, Direction direction) {
        int skyLight = 15;
        int light = 0xF000F0;
        vertexConsumer.addVertex(matrix, xStart, yStart, z1).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yStart, z2).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xEnd, yEnd, z3).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
        vertexConsumer.addVertex(matrix, xStart, yEnd, z4).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255).setUv2(light, skyLight);
    }

    protected RenderType renderType() {
        return XP_FIELD;
    }
}

