/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CaptivatingEffect
extends MobEffect {
    public CaptivatingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        double mobSearchRadius = 4.0;
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.blockPosition();
        if (!level.isClientSide()) {
            List mobToMove = level.getEntitiesOfClass(Monster.class, new AABB((double)pos.getX() - mobSearchRadius + (double)amplifier, (double)pos.getY() - mobSearchRadius + (double)amplifier, (double)pos.getZ() - mobSearchRadius + (double)amplifier, (double)pos.getX() + mobSearchRadius + (double)amplifier, (double)pos.getY() + mobSearchRadius + (double)amplifier, (double)pos.getZ() + mobSearchRadius + (double)amplifier));
            for (Monster monster : mobToMove) {
                if (mobToMove == livingEntity) continue;
                double xMov = livingEntity.getKnownMovement().x;
                double yMov = livingEntity.getKnownMovement().y;
                double zMov = livingEntity.getKnownMovement().z;
                monster.resetFallDistance();
                monster.setDeltaMovement(xMov, yMov, zMov);
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

