/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;
import net.quasar.abysstech.util.AbyssTechEffectUtility;

public class DesperationEffect
extends MobEffect {
    public DesperationEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.ATTACK_DAMAGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_desperation_strength"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.DESPERATION_EFFECT)) != null) {
            int duration = effect.getDuration();
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_desperation_strength"));
            AttributeModifier desperationStrength = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_desperation_strength"), AbyssTechEffectUtility.setDecreasingStat(duration, 0.002, amplifier, 4.0), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).addTransientModifier(desperationStrength);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

