/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class DiverEffect
extends MobEffect {
    public DiverEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.WATER_MOVEMENT_EFFICIENCY)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_diver_swim"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.DIVER_EFFECT)) != null) {
            livingEntity.setAirSupply(300);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.WATER_MOVEMENT_EFFICIENCY)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_diver_swim"));
            AttributeModifier diverSwimSpeed = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_diver_swim"), 1.0 + (double)amplifier * 0.6, AttributeModifier.Operation.ADD_VALUE);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.WATER_MOVEMENT_EFFICIENCY)).addTransientModifier(diverSwimSpeed);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

