/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class DwellerEffect
extends MobEffect {
    public DwellerEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.MOVEMENT_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_speed"));
        Objects.requireNonNull(attributeMap.getInstance(Attributes.ATTACK_DAMAGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_strength"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.getOnPos();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.DWELLER_EFFECT)) != null) {
            if (level.canSeeSky(pos.above(1)) && level.isDay()) {
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_speed"));
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_strength"));
                AttributeModifier dwellerSpeed = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_speed"), -0.003 - (double)amplifier * 0.005, AttributeModifier.Operation.ADD_VALUE);
                AttributeModifier dwellerStrength = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_strength"), -0.003 - (double)amplifier * 0.005, AttributeModifier.Operation.ADD_VALUE);
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).addTransientModifier(dwellerSpeed);
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).addTransientModifier(dwellerStrength);
            } else {
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_speed"));
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_strength"));
                AttributeModifier dwellerSpeed = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_speed"), 0.03 + (double)amplifier * 0.015, AttributeModifier.Operation.ADD_VALUE);
                AttributeModifier dwellerStrength = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_dweller_strength"), 0.03 + (double)amplifier * 0.015, AttributeModifier.Operation.ADD_VALUE);
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).addTransientModifier(dwellerSpeed);
                Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).addTransientModifier(dwellerStrength);
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

