/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.util.AbyssTechUtility;

public class ElectrifyingEffect
extends MobEffect {
    Random random = new Random();

    public ElectrifyingEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.blockPosition();
        if (!level.isClientSide() && this.random.nextInt(10) > 7) {
            int range = 30 + 3 * amplifier;
            BlockPos radiusPos = pos.offset(this.random.nextInt(range) - range / 2, 0, this.random.nextInt(range) - range / 2);
            AbyssTechUtility.MobSimpleSpawn(level, radiusPos, EntityType.LIGHTNING_BOLT.create(level));
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

