/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;

public class ExplosiveExitEffect
extends MobEffect {
    private int amp = 0;
    private Level level = null;
    private BlockPos pos = null;

    public ExplosiveExitEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        if (this.level != null && this.pos != null) {
            this.level.explode(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), 2.0f + (float)this.amp, Level.ExplosionInteraction.TNT);
        }
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level l = livingEntity.level();
        BlockPos p = livingEntity.blockPosition();
        if (!l.isClientSide()) {
            this.amp = amplifier;
            this.level = l;
            this.pos = p;
            ((ServerLevel)l).sendParticles((ParticleOptions)ParticleTypes.LAVA, (double)((float)p.getX() + 0.5f), (double)((float)p.getY() + 2.2f), (double)((float)p.getZ() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

