/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class GiantEffect
extends MobEffect {
    public GiantEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.SCALE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_giant_scale"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.GIANT_EFFECT)) != null) {
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.SCALE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_giant_scale"));
            AttributeModifier giantScale = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_giant_scale"), (double)(1 + amplifier), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.SCALE)).addTransientModifier(giantScale);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

