/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.util.AbyssTechTags;

public class GrassFleshEffect
extends MobEffect {
    private final int tickRate = 100;
    private int currentTick = 0;

    public GrassFleshEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.getOnPos();
        if (!level.isClientSide()) {
            if (this.currentTick >= 100 - amplifier * 2) {
                this.currentTick = 0;
                if (level.getBlockState(pos).is(AbyssTechTags.Blocks.GRASS_LIKE)) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 80 + amplifier * 5, (int)((double)amplifier * 0.25)));
                }
            }
            ++this.currentTick;
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

