/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GreedyGraspEffect
extends MobEffect {
    public GreedyGraspEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        double mobSearchRadius = 4.0 + (double)amplifier * 2.0;
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.blockPosition();
        if (!level.isClientSide()) {
            List itemToMove = level.getEntitiesOfClass(ItemEntity.class, new AABB((double)pos.getX() - mobSearchRadius, (double)pos.getY() - mobSearchRadius, (double)pos.getZ() - mobSearchRadius, (double)pos.getX() + mobSearchRadius, (double)pos.getY() + mobSearchRadius, (double)pos.getZ() + mobSearchRadius));
            for (ItemEntity entity : itemToMove) {
                entity.teleportTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

