/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.util.AbyssTechUtility;

public class HatefulEyeEffect
extends MobEffect {
    public HatefulEyeEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        double mobSearchRadius = 5.0 + (double)amplifier / 2.0;
        Level level = livingEntity.level();
        if (!level.isClientSide()) {
            BlockPos lookPos = AbyssTechUtility.getLookBlockPosCollider(level, livingEntity, 0.5f, 5 + amplifier);
            List mobToMove = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)lookPos.getX() - mobSearchRadius, (double)lookPos.getY() - mobSearchRadius, (double)lookPos.getZ() - mobSearchRadius, (double)lookPos.getX() + mobSearchRadius, (double)lookPos.getY() + mobSearchRadius, (double)lookPos.getZ() + mobSearchRadius));
            for (LivingEntity entity : mobToMove) {
                if (mobToMove == livingEntity) continue;
                double moveStrength = 0.2;
                double moveX = Math.signum(entity.getX() - (double)lookPos.getX()) * moveStrength;
                double moveZ = Math.signum(entity.getZ() - (double)lookPos.getZ()) * moveStrength;
                entity.setDeltaMovement(entity.getDeltaMovement().add(moveX, 0.0, moveZ));
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

