/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class InfernalEffect
extends MobEffect {
    public InfernalEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.blockPosition();
        int mobSearchRadius = 4;
        if (!level.isClientSide()) {
            List mobToIgnite = level.getEntitiesOfClass(Monster.class, new AABB((double)(pos.getX() - mobSearchRadius + amplifier), (double)(pos.getY() - mobSearchRadius + amplifier), (double)(pos.getZ() - mobSearchRadius + amplifier), (double)(pos.getX() + mobSearchRadius + amplifier), (double)(pos.getY() + mobSearchRadius + amplifier), (double)(pos.getZ() + mobSearchRadius + amplifier)));
            for (Monster monster : mobToIgnite) {
                if (mobToIgnite == livingEntity) continue;
                monster.setRemainingFireTicks(20);
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

