/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.quasar.abysstech.effect.AbyssTechEffects;
import net.quasar.abysstech.util.AbyssTechUtility;

public class NullPullEffect
extends MobEffect {
    public NullPullEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        Vec3 pos = livingEntity.position();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.NULL_PULL_EFFECT)) != null) {
            int duration = effect.getDuration();
            if (duration < 5) {
                livingEntity.setNoGravity(false);
            } else {
                Player player;
                livingEntity.setNoGravity(true);
                Vec3 lookPos = AbyssTechUtility.getLookPos(livingEntity, 3.0f);
                if (livingEntity instanceof Player && (player = (Player)livingEntity).isShiftKeyDown()) {
                    if (lookPos.y > pos.y) {
                        player.setDeltaMovement(player.getDeltaMovement().add(0.0, player.getDeltaMovement().y > (double)(0.3f + (float)amplifier * 0.2f) ? 0.0 : (double)(0.003f + (float)amplifier * 0.003f), 0.0));
                        AbyssTechUtility.syncMovement(player);
                    } else if (lookPos.y < pos.y) {
                        player.setDeltaMovement(player.getDeltaMovement().add(0.0, player.getDeltaMovement().y < (double)(-0.3f - (float)amplifier * 0.2f) ? 0.0 : (double)(-(0.003f + (float)amplifier * 0.003f)), 0.0));
                        AbyssTechUtility.syncMovement(player);
                    }
                }
                livingEntity.resetFallDistance();
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

