/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class RepulsiveEffect
extends MobEffect {
    public RepulsiveEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        double mobSearchRadius = 4.0;
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.blockPosition();
        if (!level.isClientSide()) {
            List mobToMove = level.getEntitiesOfClass(Monster.class, new AABB((double)pos.getX() - mobSearchRadius + (double)amplifier, (double)pos.getY() - mobSearchRadius + (double)amplifier, (double)pos.getZ() - mobSearchRadius + (double)amplifier, (double)pos.getX() + mobSearchRadius + (double)amplifier, (double)pos.getY() + mobSearchRadius + (double)amplifier, (double)pos.getZ() + mobSearchRadius + (double)amplifier));
            for (Monster monster : mobToMove) {
                if (mobToMove == livingEntity) continue;
                double moveStrength = 0.2;
                double moveX = Math.signum(monster.getX() - (double)pos.getX()) * moveStrength;
                double moveZ = Math.signum(monster.getZ() - (double)pos.getZ()) * moveStrength;
                monster.setDeltaMovement(monster.getDeltaMovement().add(moveX, 0.0, moveZ));
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

