/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class ScarletEffect
extends MobEffect {
    public ScarletEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        MobEffectInstance effect = livingEntity.getEffect(AbyssTechEffects.SCARLET_EFFECT);
        if (effect != null && !level.isClientSide()) {
            BlockPos pos = livingEntity.getOnPos();
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SQUID_INK, (double)pos.getX(), (double)((float)pos.getY() + 1.0f), (double)pos.getZ(), 4, 3.0, 3.0, 3.0, 0.0);
            if (effect.getDuration() <= 1) {
                livingEntity.addEffect(new MobEffectInstance(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT, 320, 0));
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.getOnPos();
        if (!level.isClientSide()) {
            int searchRadius = Math.max(amplifier, 1) * 8;
            List monsters = level.getEntitiesOfClass(Monster.class, new AABB((double)(pos.getX() - searchRadius), (double)(pos.getY() - searchRadius), (double)(pos.getZ() - searchRadius), (double)(pos.getX() + searchRadius), (double)(pos.getY() + searchRadius), (double)(pos.getZ() + searchRadius)));
            for (Monster monster : monsters) {
                monster.addEffect(new MobEffectInstance(MobEffects.GLOWING, 160, 0));
            }
            livingEntity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 160, 0));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 160, 0));
        }
        super.onEffectStarted(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

