/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class SecondWindEffect
extends MobEffect {
    public SecondWindEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        if (!level.isClientSide()) {
            float currentHealth = livingEntity.getHealth();
            MobEffectInstance effect = livingEntity.getEffect(AbyssTechEffects.SECOND_WIND_EFFECT);
            if (effect != null && currentHealth < 4.0f) {
                livingEntity.setHealth(livingEntity.getMaxHealth());
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, (int)((double)amplifier * 0.3)));
                livingEntity.removeEffect(AbyssTechEffects.SECOND_WIND_EFFECT);
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

