/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.util.AbyssTechUtility;

public class SkiesEyeEffect
extends MobEffect {
    private final int tickRate = 60;
    private int currentTick = 0;

    public SkiesEyeEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        Level level = livingEntity.level();
        if (!level.isClientSide()) {
            if (this.currentTick >= 60 - amplifier * 6) {
                this.currentTick = 0;
                BlockPos lookPos = AbyssTechUtility.getLookBlockPosCollider(level, livingEntity, 0.5f, 8 + amplifier * 3);
                AbyssTechUtility.MobSimpleSpawn(level, lookPos, EntityType.LIGHTNING_BOLT.create(level));
            }
            ++this.currentTick;
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

