/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class SpiteEffect
extends MobEffect {
    public SpiteEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.ATTACK_DAMAGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_spite_strength"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.SPITE_EFFECT)) != null) {
            float lostHealth = livingEntity.getMaxHealth() - livingEntity.getHealth();
            float modifier = lostHealth * 0.01f + (float)amplifier * (lostHealth * 5.0E-4f);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_spite_strength"));
            AttributeModifier spiteStrength = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_spite_strength"), (double)modifier, AttributeModifier.Operation.ADD_VALUE);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).addTransientModifier(spiteStrength);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

