/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;
import net.quasar.abysstech.util.AbyssTechEffectUtility;

public class SprinterEffect
extends MobEffect {
    public SprinterEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.MOVEMENT_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_sprinter_speed"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.SPRINTER_EFFECT)) != null) {
            int duration = effect.getDuration();
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_sprinter_speed"));
            AttributeModifier sprinterSpeed = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_sprinter_speed"), AbyssTechEffectUtility.setIncreasingStat(duration, 3.0, 30.0 + (double)(3 * amplifier)), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)).addTransientModifier(sprinterSpeed);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

