/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class TelekinesisEffect
extends MobEffect {
    public TelekinesisEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.ENTITY_INTERACTION_RANGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.telekinesis_effect_hand"));
        Objects.requireNonNull(attributeMap.getInstance(Attributes.BLOCK_INTERACTION_RANGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.telekinesis_effect_block"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.TELEKINESIS_EFFECT)) != null) {
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.telekinesis_effect_hand"));
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.BLOCK_INTERACTION_RANGE)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.telekinesis_effect_block"));
            AttributeModifier telekinesis_hand = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.telekinesis_effect_hand"), 1.0 + (double)(amplifier * 2), AttributeModifier.Operation.ADD_VALUE);
            AttributeModifier telekinesis_block = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.telekinesis_effect_block"), 1.0 + (double)(amplifier * 2), AttributeModifier.Operation.ADD_VALUE);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)).addTransientModifier(telekinesis_hand);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.BLOCK_INTERACTION_RANGE)).addTransientModifier(telekinesis_block);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

