/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class TestEffect
extends MobEffect {
    public TestEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.STEP_HEIGHT)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.test_effect"));
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        BlockPos pos = livingEntity.blockPosition();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.TEST_EFFECT)) != null) {
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.STEP_HEIGHT)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.test_effect"));
            AttributeModifier testE = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.test_effect"), 1.0 + (double)(amplifier * 2), AttributeModifier.Operation.ADD_VALUE);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.STEP_HEIGHT)).addTransientModifier(testE);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

