/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.effect;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.effect.AbyssTechEffects;

public class WithTheWindEffect
extends MobEffect {
    public WithTheWindEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        super.removeAttributeModifiers(attributeMap);
        Objects.requireNonNull(attributeMap.getInstance(Attributes.ATTACK_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_wind_swing"));
        Objects.requireNonNull(attributeMap.getInstance(Attributes.BLOCK_BREAK_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_wind_haste"));
    }

    private double setEntityActionSpeed(double currentSpeed, int amplifier) {
        return currentSpeed + currentSpeed * ((double)amplifier * 0.3);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        MobEffectInstance effect;
        Level level = livingEntity.level();
        if (!level.isClientSide() && (effect = livingEntity.getEffect(AbyssTechEffects.WITH_THE_WIND_EFFECT)) != null) {
            double currentSpeed = livingEntity.getSpeed();
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_wind_swing"));
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.BLOCK_BREAK_SPEED)).removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_wind_haste"));
            AttributeModifier windSwing = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_wind_swing"), this.setEntityActionSpeed(currentSpeed, amplifier), AttributeModifier.Operation.ADD_VALUE);
            AttributeModifier windHaste = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.abyssal_wind_haste"), this.setEntityActionSpeed(currentSpeed, amplifier), AttributeModifier.Operation.ADD_VALUE);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_SPEED)).addTransientModifier(windSwing);
            Objects.requireNonNull(livingEntity.getAttribute(Attributes.BLOCK_BREAK_SPEED)).addTransientModifier(windHaste);
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

