/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.quasar.abysstech.entity.client.ChattererAnimations;
import net.quasar.abysstech.entity.custom.ChattererEntity;

public class ChattererModel
extends HierarchicalModel<ChattererEntity> {
    private final ModelPart chatterer;
    private final ModelPart upper_body_group;
    private final ModelPart staff;
    private final ModelPart body;
    private final ModelPart chain;
    private final ModelPart chain_two;
    private final ModelPart chain_three;
    private final ModelPart chain_four;
    private final ModelPart left_arm;
    private final ModelPart left_lower_arm;
    private final ModelPart right_arm;
    private final ModelPart right_lower_arm;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart coffin;
    private final ModelPart coffin_lid;
    private final ModelPart lower_body_group;
    private final ModelPart left_leg;
    private final ModelPart left_lower_leg;
    private final ModelPart right_leg;
    private final ModelPart right_lower_leg;

    public ChattererModel(ModelPart root) {
        this.chatterer = root.getChild("chatterer");
        this.upper_body_group = this.chatterer.getChild("upper_body_group");
        this.staff = this.upper_body_group.getChild("staff");
        this.body = this.upper_body_group.getChild("body");
        this.chain = this.body.getChild("chain");
        this.chain_two = this.chain.getChild("chain_two");
        this.chain_three = this.chain_two.getChild("chain_three");
        this.chain_four = this.chain_three.getChild("chain_four");
        this.left_arm = this.body.getChild("left_arm");
        this.left_lower_arm = this.left_arm.getChild("left_lower_arm");
        this.right_arm = this.body.getChild("right_arm");
        this.right_lower_arm = this.right_arm.getChild("right_lower_arm");
        this.head = this.body.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.coffin = this.body.getChild("coffin");
        this.coffin_lid = this.coffin.getChild("coffin_lid");
        this.lower_body_group = this.chatterer.getChild("lower_body_group");
        this.left_leg = this.lower_body_group.getChild("left_leg");
        this.left_lower_leg = this.left_leg.getChild("left_lower_leg");
        this.right_leg = this.lower_body_group.getChild("right_leg");
        this.right_lower_leg = this.right_leg.getChild("right_lower_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition chatterer = partdefinition.addOrReplaceChild("chatterer", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition upper_body_group = chatterer.addOrReplaceChild("upper_body_group", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition staff = upper_body_group.addOrReplaceChild("staff", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, 8.0631f, -12.7738f, 2.0f, 2.0f, 34.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-12.0f, 9.0631f, -22.7738f, 12.0f, 0.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-1.0f, (float)-1.9199f, (float)0.0f, (float)0.0f));
        PartDefinition body = upper_body_group.addOrReplaceChild("body", CubeListBuilder.create().texOffs(74, 71).addBox(-4.0f, -1.9f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(38, 56).addBox(-6.0f, -1.9f, -3.0f, 12.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chain = body.addOrReplaceChild("chain", CubeListBuilder.create().texOffs(-3, 123).addBox(-7.0f, 2.1f, -5.0f, 14.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(3, 121).addBox(-7.0f, 1.1f, -4.0f, 14.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition chain_two = chain.addOrReplaceChild("chain_two", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)2.0f, (float)-4.0f));
        PartDefinition cube_r1 = chain_two.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(-19, 0).addBox(-1.0f, 0.0f, -15.0f, 2.0f, 0.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.1f, (float)17.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition cube_r2 = chain_two.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 100).addBox(0.0f, -1.0f, -19.0f, 0.0f, 2.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.1f, (float)17.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        PartDefinition chain_three = chain_two.addOrReplaceChild("chain_three", CubeListBuilder.create().texOffs(0, 117).addBox(-17.0f, -0.9f, 0.0f, 18.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-2, 115).addBox(-17.0f, 0.1f, -1.0f, 18.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)17.0f));
        PartDefinition chain_four = chain_three.addOrReplaceChild("chain_four", CubeListBuilder.create(), PartPose.offset((float)-16.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = chain_four.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 100).addBox(0.0f, -1.0f, -17.0f, 0.0f, 2.0f, 19.0f, new CubeDeformation(0.0f)).texOffs(-19, 0).addBox(-1.0f, 0.0f, -17.0f, 2.0f, 0.0f, 19.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.1f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 103).addBox(0.0f, -1.9f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(62, 87).addBox(-1.0f, -2.9f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)0.0f, (float)-0.1752f, (float)0.0151f, (float)-0.0859f));
        PartDefinition left_lower_arm = left_arm.addOrReplaceChild("left_lower_arm", CubeListBuilder.create().texOffs(104, 12).addBox(-1.9f, 0.1f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)6.0f, (float)0.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(72, 103).addBox(-4.0f, -1.9f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(38, 86).addBox(-5.0f, -2.9f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.9606f, (float)-0.0151f, (float)0.0859f));
        PartDefinition right_lower_arm = right_arm.addOrReplaceChild("right_lower_arm", CubeListBuilder.create().texOffs(104, 103).addBox(-2.1f, 0.1f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)6.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(74, 55).addBox(-4.0f, -9.5671f, -3.9526f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(108, 68).addBox(-3.5f, -2.8171f, -3.7026f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(108, 68).addBox(-3.6f, -2.3171f, -1.7026f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(108, 68).addBox(3.6f, -2.5671f, -1.7026f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(108, 68).addBox(3.5f, -2.5671f, -3.7026f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(108, 69).addBox(-1.5f, -3.0671f, -3.7026f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(108, 69).addBox(0.5f, -2.0671f, -3.7026f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(108, 69).addBox(2.5f, -2.5671f, -3.7026f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(108, 69).addBox(-3.5f, -2.8171f, -3.7026f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(72, 30).addBox(-4.5f, -10.0671f, -4.4526f, 9.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(98, 77).addBox(-4.0f, -1.5671f, 0.0474f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(38, 0).addBox(-4.0f, -11.0f, -5.0f, 9.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-0.0671f, (float)-0.4526f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(38, 8).addBox(5.0f, -11.0f, -5.0f, 0.0f, 16.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-0.0671f, (float)-0.4526f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r6 = head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(95, 58).addBox(-6.0f, -11.0f, -7.0f, 11.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.7f, (float)0.8329f, (float)0.1974f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(98, 71).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(106, 69).addBox(-3.6f, -1.5f, -3.75f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(106, 69).addBox(-1.5f, -1.25f, -3.75f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(106, 69).addBox(0.5f, -0.75f, -3.75f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(106, 69).addBox(2.6f, -1.5f, -3.75f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(106, 68).addBox(-3.5f, -1.0f, -1.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(106, 68).addBox(3.5f, -1.25f, -1.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(106, 68).addBox(-3.6f, -1.5f, -3.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(106, 68).addBox(3.6f, -1.5f, -3.75f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5671f, (float)0.0474f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition coffin = body.addOrReplaceChild("coffin", CubeListBuilder.create().texOffs(0, 56).addBox(-7.0f, -9.9f, 0.0f, 14.0f, 28.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)5.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition coffin_lid = coffin.addOrReplaceChild("coffin_lid", CubeListBuilder.create().texOffs(72, 0).addBox(-14.0f, -12.9f, 0.0f, 14.0f, 28.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)3.0f, (float)5.0f));
        PartDefinition lower_body_group = chatterer.addOrReplaceChild("lower_body_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition left_leg = lower_body_group.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(40, 102).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 89).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)-0.2624f, (float)-0.1272f, (float)-0.0844f));
        PartDefinition left_lower_leg = left_leg.addOrReplaceChild("left_lower_leg", CubeListBuilder.create().texOffs(104, 0).addBox(-1.9f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = lower_body_group.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 102).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(86, 87).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.2624f, (float)0.1272f, (float)0.0844f));
        PartDefinition right_lower_leg = right_leg.addOrReplaceChild("right_lower_leg", CubeListBuilder.create().texOffs(88, 103).addBox(-2.1f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(ChattererEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animate(entity.idleAnimationState, ChattererAnimations.idle, ageInTicks, 1.0f);
        this.animate(entity.attackAnimationState, ChattererAnimations.attack, ageInTicks, 1.5f);
        this.animate(entity.openAnimationState, ChattererAnimations.coffin, ageInTicks, 1.0f);
        this.animate(entity.closeAnimationState, ChattererAnimations.coffin_close, ageInTicks, 1.0f);
        this.animateWalk(ChattererAnimations.walk, limbSwing, limbSwingAmount, 1.0f, 2.5f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.chatterer.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.chatterer;
    }
}

