/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.quasar.abysstech.entity.client.HomunculiAnimations;
import net.quasar.abysstech.entity.custom.HomunculiEntity;

public class HomunculiModel
extends HierarchicalModel<HomunculiEntity> {
    private final ModelPart homunculi;
    private final ModelPart upper_body_group;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart left_arm_lower;
    private final ModelPart right_arm;
    private final ModelPart right_arm_lower;
    private final ModelPart head;
    private final ModelPart lower_body_group;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public HomunculiModel(ModelPart root) {
        this.homunculi = root.getChild("homunculi");
        this.upper_body_group = this.homunculi.getChild("upper_body_group");
        this.body = this.upper_body_group.getChild("body");
        this.left_arm = this.body.getChild("left_arm");
        this.left_arm_lower = this.left_arm.getChild("left_arm_lower");
        this.right_arm = this.body.getChild("right_arm");
        this.right_arm_lower = this.right_arm.getChild("right_arm_lower");
        this.head = this.body.getChild("head");
        this.lower_body_group = this.homunculi.getChild("lower_body_group");
        this.left_leg = this.lower_body_group.getChild("left_leg");
        this.right_leg = this.lower_body_group.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition homunculi = partdefinition.addOrReplaceChild("homunculi", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition upper_body_group = homunculi.addOrReplaceChild("upper_body_group", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.75f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body = upper_body_group.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 18).addBox(-4.0f, -2.0f, -2.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(0, 34).addBox(0.0f, -1.9f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-2.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)-0.0436f));
        PartDefinition left_arm_lower = left_arm.addOrReplaceChild("left_arm_lower", CubeListBuilder.create().texOffs(48, 0).addBox(0.0f, 0.1f, -2.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 48).addBox(-2.0f, 0.1f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)8.0f, (float)0.0f, (float)-0.1314f, (float)-0.0865f, (float)0.0114f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(44, 30).addBox(-4.0f, -1.9f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-2.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0436f));
        PartDefinition right_arm_lower = right_arm.addOrReplaceChild("right_arm_lower", CubeListBuilder.create().texOffs(16, 34).addBox(0.0f, 0.1f, -2.0f, 0.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 44).addBox(-2.0f, 0.1f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)8.0f, (float)0.0f, (float)-0.1314f, (float)0.0865f, (float)-0.0114f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(28, 52).addBox(-4.5f, -9.0f, -4.5f, 9.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 18).addBox(-3.5f, -9.5f, -3.5f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(16, 48).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.1744f, (float)0.0076f, (float)-0.043f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(-8, 56).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-11.0f, (float)5.0f, (float)-0.6275f, (float)-0.8311f, (float)1.652f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(-8, 56).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)-11.0f, (float)1.0f, (float)1.3797f, (float)-0.7903f, (float)-0.6063f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-8, 56).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-11.0f, (float)1.0f, (float)2.267f, (float)-1.1131f, (float)0.1813f));
        PartDefinition cube_r4 = head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(-8, 56).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-12.0f, (float)1.0f, (float)0.6198f, (float)-1.2659f, (float)1.0784f));
        PartDefinition cube_r5 = head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(-8, 56).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)5.0f, (float)-0.6685f, (float)0.0091f, (float)1.454f));
        PartDefinition cube_r6 = head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(-8, 56).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)-7.0f, (float)6.0f, (float)0.7278f, (float)0.0091f, (float)1.454f));
        PartDefinition cube_r7 = head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(-8, 56).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-11.0f, (float)5.0f, (float)0.6759f, (float)-0.5486f, (float)0.8701f));
        PartDefinition lower_body_group = homunculi.addOrReplaceChild("lower_body_group", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = lower_body_group.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)-0.0436f));
        PartDefinition right_leg = lower_body_group.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(28, 30).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0436f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(HomunculiEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animate(entity.idleAnimationState, HomunculiAnimations.idle, ageInTicks, 1.0f);
        this.animate(entity.attackAnimationState, HomunculiAnimations.attack, ageInTicks, 1.2f);
        this.animateWalk(HomunculiAnimations.walk, limbSwing, limbSwingAmount, 1.0f, 2.5f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.homunculi.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.homunculi;
    }
}

