/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.quasar.abysstech.entity.client.HuggingSludgeAnimations;
import net.quasar.abysstech.entity.custom.HuggingSludgeEntity;

public class HuggingSludgeModel
extends HierarchicalModel<HuggingSludgeEntity> {
    private final ModelPart hugging_sludge;
    private final ModelPart upper_body_group;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart head;
    private final ModelPart left_body;
    private final ModelPart right_body;
    private final ModelPart spine;
    private final ModelPart bottom_jaw;
    private final ModelPart lower_body_group;
    private final ModelPart left_leg;
    private final ModelPart right_leg;

    public HuggingSludgeModel(ModelPart root) {
        this.hugging_sludge = root.getChild("hugging_sludge");
        this.upper_body_group = this.hugging_sludge.getChild("upper_body_group");
        this.body = this.upper_body_group.getChild("body");
        this.left_arm = this.body.getChild("left_arm");
        this.right_arm = this.body.getChild("right_arm");
        this.head = this.body.getChild("head");
        this.left_body = this.body.getChild("left_body");
        this.right_body = this.body.getChild("right_body");
        this.spine = this.body.getChild("spine");
        this.bottom_jaw = this.body.getChild("bottom_jaw");
        this.lower_body_group = this.hugging_sludge.getChild("lower_body_group");
        this.left_leg = this.lower_body_group.getChild("left_leg");
        this.right_leg = this.lower_body_group.getChild("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition hugging_sludge = partdefinition.addOrReplaceChild("hugging_sludge", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition upper_body_group = hugging_sludge.addOrReplaceChild("upper_body_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = upper_body_group.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 32).addBox(0.0f, -1.9f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(42, 16).addBox(-4.0f, -1.9f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, 0.0f, 8.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(44, 12).addBox(-2.5f, -5.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(14, 48).addBox(1.5f, -5.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 16).addBox(-3.5f, -9.3296f, -0.7059f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_body = body.addOrReplaceChild("left_body", CubeListBuilder.create().texOffs(0, 31).addBox(-4.0f, 0.0f, -4.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(8, 47).addBox(-7.0f, 0.0f, -3.0f, 3.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-2.0f, (float)2.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition right_body = body.addOrReplaceChild("right_body", CubeListBuilder.create().texOffs(16, 32).addBox(0.0f, 0.0f, -4.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(44, 0).addBox(4.0f, 0.0f, -3.0f, 3.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-2.0f, (float)2.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition spine = body.addOrReplaceChild("spine", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition cube_r2 = spine.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 47).addBox(0.0f, -3.0f, 0.0f, 0.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition cube_r3 = spine.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 47).addBox(0.0f, -3.0f, 0.0f, 0.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition bottom_jaw = body.addOrReplaceChild("bottom_jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)6.0f, (float)-2.0f));
        PartDefinition cube_r4 = bottom_jaw.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 16).addBox(-3.5f, -4.5f, -2.0f, 7.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)-3.1416f));
        PartDefinition lower_body_group = hugging_sludge.addOrReplaceChild("lower_body_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition left_leg = lower_body_group.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(28, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = lower_body_group.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(26, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(HuggingSludgeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animate(entity.idleAnimationState, HuggingSludgeAnimations.idle, ageInTicks, 1.0f);
        this.animate(entity.attackAnimationState, HuggingSludgeAnimations.crunch, ageInTicks, 1.5f);
        this.animateWalk(HuggingSludgeAnimations.walk, limbSwing, limbSwingAmount, 1.0f, 2.5f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.hugging_sludge.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.hugging_sludge;
    }
}

