/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.quasar.abysstech.entity.client.LadybugAnimations;
import net.quasar.abysstech.entity.custom.LadybugEntity;

public class LadybugModel
extends HierarchicalModel<LadybugEntity> {
    private final ModelPart ladybug;
    private final ModelPart upper_body_group;
    private final ModelPart body;
    private final ModelPart right_under_wing;
    private final ModelPart left_under_wing;
    private final ModelPart head_group;
    private final ModelPart head;
    private final ModelPart left_wing;
    private final ModelPart right_wing;
    private final ModelPart feet;
    private final ModelPart right;
    private final ModelPart right2;
    private final ModelPart right3;
    private final ModelPart left;
    private final ModelPart left2;
    private final ModelPart left3;

    public LadybugModel(ModelPart root) {
        this.ladybug = root.getChild("ladybug");
        this.upper_body_group = this.ladybug.getChild("upper_body_group");
        this.body = this.upper_body_group.getChild("body");
        this.right_under_wing = this.body.getChild("right_under_wing");
        this.left_under_wing = this.body.getChild("left_under_wing");
        this.head_group = this.body.getChild("head_group");
        this.head = this.ladybug.getChild("upper_body_group").getChild("body").getChild("head_group");
        this.left_wing = this.body.getChild("left_wing");
        this.right_wing = this.body.getChild("right_wing");
        this.feet = this.ladybug.getChild("feet");
        this.right = this.feet.getChild("right");
        this.right2 = this.feet.getChild("right2");
        this.right3 = this.feet.getChild("right3");
        this.left = this.feet.getChild("left");
        this.left2 = this.feet.getChild("left2");
        this.left3 = this.feet.getChild("left3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition ladybug = partdefinition.addOrReplaceChild("ladybug", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition upper_body_group = ladybug.addOrReplaceChild("upper_body_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = upper_body_group.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -3.0f, -5.0f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_under_wing = body.addOrReplaceChild("right_under_wing", CubeListBuilder.create().texOffs(-10, 54).addBox(-3.0f, 0.0f, 0.0f, 5.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-3.1f, (float)-5.0f));
        PartDefinition left_under_wing = body.addOrReplaceChild("left_under_wing", CubeListBuilder.create().texOffs(0, 54).addBox(-2.0f, 0.0f, 0.0f, 5.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.1f, (float)-5.0f));
        PartDefinition head_group = body.addOrReplaceChild("head_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-5.0f));
        PartDefinition head = head_group.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 15).addBox(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(32, 31).addBox(0.0f, -4.0f, -5.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-1.0f, (float)-2.0f, (float)-0.1745f, (float)-0.6109f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 22).addBox(0.0f, -4.0f, -5.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-1.0f, (float)-2.0f, (float)-0.1745f, (float)0.6109f, (float)0.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 15).addBox(-4.75f, -0.5f, -0.25f, 5.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-3.0f, (float)-5.0f));
        PartDefinition right_wing = body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 31).addBox(-0.25f, -0.5f, -0.25f, 5.0f, 5.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-3.0f, (float)-5.0f));
        PartDefinition feet = ladybug.addOrReplaceChild("feet", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition right = feet.addOrReplaceChild("right", CubeListBuilder.create().texOffs(40, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)-3.0f));
        PartDefinition right2 = feet.addOrReplaceChild("right2", CubeListBuilder.create().texOffs(40, 4).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)0.0f));
        PartDefinition right3 = feet.addOrReplaceChild("right3", CubeListBuilder.create().texOffs(40, 8).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)3.0f));
        PartDefinition left = feet.addOrReplaceChild("left", CubeListBuilder.create().texOffs(32, 40).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)-3.0f));
        PartDefinition left2 = feet.addOrReplaceChild("left2", CubeListBuilder.create().texOffs(40, 40).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition left3 = feet.addOrReplaceChild("left3", CubeListBuilder.create().texOffs(42, 22).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(LadybugEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(LadybugAnimations.walk, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        this.animate(entity.idleAnimationState, LadybugAnimations.idle, ageInTicks, 1.0f);
        this.animate(entity.wingAnimationState, LadybugAnimations.wing, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.ladybug.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.ladybug;
    }
}

