/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.quasar.abysstech.entity.client.SludgeSporeAnimations;
import net.quasar.abysstech.entity.custom.SludgeSporeEntity;

public class SludgeSporeModel
extends HierarchicalModel<SludgeSporeEntity> {
    private final ModelPart sludge_spore;
    private final ModelPart upper_body_group;
    private final ModelPart head;
    private final ModelPart left_cheek;
    private final ModelPart right_cheek;
    private final ModelPart tail;
    private final ModelPart tail_two;
    private final ModelPart tail_three;
    private final ModelPart index_finger;
    private final ModelPart middle_finger;
    private final ModelPart pinky_finger;
    private final ModelPart thumb;

    public SludgeSporeModel(ModelPart root) {
        this.sludge_spore = root.getChild("sludge_spore");
        this.upper_body_group = this.sludge_spore.getChild("upper_body_group");
        this.head = this.upper_body_group.getChild("head");
        this.left_cheek = this.head.getChild("left_cheek");
        this.right_cheek = this.head.getChild("right_cheek");
        this.tail = this.upper_body_group.getChild("tail");
        this.tail_two = this.tail.getChild("tail_two");
        this.tail_three = this.tail_two.getChild("tail_three");
        this.index_finger = this.tail_three.getChild("index_finger");
        this.middle_finger = this.tail_three.getChild("middle_finger");
        this.pinky_finger = this.tail_three.getChild("pinky_finger");
        this.thumb = this.tail_three.getChild("thumb");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition sludge_spore = partdefinition.addOrReplaceChild("sludge_spore", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition upper_body_group = sludge_spore.addOrReplaceChild("upper_body_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = upper_body_group.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-3.0f, 4.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_cheek = head.addOrReplaceChild("left_cheek", CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, -4.0f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)3.0f, (float)0.0f));
        PartDefinition right_cheek = head.addOrReplaceChild("right_cheek", CubeListBuilder.create().texOffs(24, 16).addBox(0.0f, -4.0f, -3.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)3.0f, (float)0.0f));
        PartDefinition tail = upper_body_group.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(20, 26).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail_two = tail.addOrReplaceChild("tail_two", CubeListBuilder.create().texOffs(28, 26).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail_three = tail_two.addOrReplaceChild("tail_three", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition cube_r1 = tail_three.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(32, 0).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition index_finger = tail_three.addOrReplaceChild("index_finger", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)2.9f, (float)1.2f));
        PartDefinition cube_r2 = index_finger.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(32, 32).addBox(-0.5f, -0.0988f, -1.0003f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.325f, (float)1.5199f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = index_finger.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(32, 4).addBox(-0.5f, -0.0858f, -0.952f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0931f, (float)0.0523f, (float)0.829f, (float)0.0f, (float)0.0f));
        PartDefinition middle_finger = tail_three.addOrReplaceChild("middle_finger", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.9f, (float)1.2f));
        PartDefinition cube_r4 = middle_finger.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(28, 32).addBox(-0.5f, -0.0988f, -1.0003f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.825f, (float)1.0199f, (float)1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = middle_finger.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(32, 7).addBox(-0.5f, -0.0858f, -0.952f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0931f, (float)0.0523f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition pinky_finger = tail_three.addOrReplaceChild("pinky_finger", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)2.9f, (float)1.2f));
        PartDefinition cube_r6 = pinky_finger.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(24, 32).addBox(-0.5f, -0.0988f, -1.0003f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.525f, (float)1.32f, (float)1.309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r7 = pinky_finger.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(32, 10).addBox(-0.5f, -0.0858f, -0.952f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0931f, (float)0.0523f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition thumb = tail_three.addOrReplaceChild("thumb", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)1.5f, (float)0.4f));
        PartDefinition cube_r8 = thumb.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(20, 32).addBox(-0.5f, -0.0042f, -0.919f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.1431f, (float)1.1023f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r9 = thumb.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(32, 13).addBox(-0.5f, -0.4523f, -0.3879f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0613f, (float)-0.1153f, (float)0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(SludgeSporeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animate(entity.idleAnimationState, SludgeSporeAnimations.idle, ageInTicks, 1.0f);
        this.animate(entity.inflateAnimationState, SludgeSporeAnimations.inflate, ageInTicks, 1.0f);
        this.animate(entity.deflateAnimationState, SludgeSporeAnimations.deflate, ageInTicks, 1.0f);
        this.animate(entity.inflateHoldAnimationState, SludgeSporeAnimations.inflate_hold, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.sludge_spore.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.sludge_spore;
    }
}

