/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.quasar.abysstech.entity.client.WanderingWispAnimations;
import net.quasar.abysstech.entity.custom.WanderingWispEntity;

public class WanderingWispModel
extends HierarchicalModel<WanderingWispEntity> {
    private final ModelPart wanderingwisp;
    private final ModelPart upper_body_group;
    private final ModelPart body;
    private final ModelPart head_group;
    private final ModelPart headtwo;
    private final ModelPart head;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private final ModelPart feet;
    private final ModelPart tail;
    private final ModelPart tail2;

    public WanderingWispModel(ModelPart root) {
        this.wanderingwisp = root.getChild("wanderingwisp");
        this.upper_body_group = this.wanderingwisp.getChild("upper_body_group");
        this.body = this.upper_body_group.getChild("body");
        this.head_group = this.body.getChild("head_group");
        this.headtwo = this.head_group.getChild("headtwo");
        this.head = this.head_group.getChild("head");
        this.leftwing = this.head_group.getChild("leftwing");
        this.rightwing = this.head_group.getChild("rightwing");
        this.feet = this.wanderingwisp.getChild("feet");
        this.tail = this.feet.getChild("tail");
        this.tail2 = this.feet.getChild("tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wanderingwisp = partdefinition.addOrReplaceChild("wanderingwisp", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition upper_body_group = wanderingwisp.addOrReplaceChild("upper_body_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = upper_body_group.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head_group = body.addOrReplaceChild("head_group", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headtwo = head_group.addOrReplaceChild("headtwo", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = headtwo.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, 0.0f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition cube_r2 = headtwo.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(22, 22).addBox(-3.0f, -6.0f, 0.0f, 6.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition head = head_group.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftwing = head_group.addOrReplaceChild("leftwing", CubeListBuilder.create(), PartPose.offset((float)2.75f, (float)1.0f, (float)-2.0f));
        PartDefinition cube_r3 = leftwing.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)0.4363f, (float)0.0f));
        PartDefinition rightwing = head_group.addOrReplaceChild("rightwing", CubeListBuilder.create(), PartPose.offset((float)-2.75f, (float)1.0f, (float)-2.0f));
        PartDefinition cube_r4 = rightwing.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, -3.0f, 0.0f, 0.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)-0.4363f, (float)0.0f));
        PartDefinition feet = wanderingwisp.addOrReplaceChild("feet", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = feet.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)-3.0f));
        PartDefinition cube_r5 = tail.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(22, 12).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = feet.addOrReplaceChild("tail2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.0f, (float)3.0f));
        PartDefinition cube_r6 = tail2.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 12).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(WanderingWispEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animate(entity.idleAnimationState, WanderingWispAnimations.idle, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.wanderingwisp.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.wanderingwisp;
    }
}

