/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.custom;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.entity.AbysstechEntities;
import net.quasar.abysstech.entity.custom.HuggingSludgeEntity;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;
import org.jetbrains.annotations.Nullable;

public class ChattererEntity
extends Monster {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState openAnimationState = new AnimationState();
    public final AnimationState closeAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int attackAnimationTimeout = 0;
    private static final EntityDataAccessor<Integer> coffinTick = SynchedEntityData.defineId(ChattererEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> coffinAnim = SynchedEntityData.defineId(ChattererEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ChattererEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, (double)1.2f, true));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{HuggingSludgeEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 35.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ENTITY_INTERACTION_RANGE, 2.5).add(Attributes.ARMOR, 3.0);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.attackAnimationTimeout >= 0) {
            --this.attackAnimationTimeout;
            if (this.attackAnimationTimeout <= 0) {
                this.attackAnimationState.stop();
            }
        }
    }

    public void swing(InteractionHand hand) {
        super.swing(hand);
        if (this.level().isClientSide()) {
            this.attackAnimationTimeout = 23;
            this.attackAnimationState.start(this.tickCount);
        }
    }

    private void coffinAnimation() {
        if (this.getCoffinAnim()) {
            switch (this.getCoffinTick()) {
                case 1: {
                    this.openAnimationState.start(this.tickCount);
                    break;
                }
                case 101: {
                    this.openAnimationState.stop();
                    this.closeAnimationState.start(this.tickCount);
                    break;
                }
                case 171: {
                    this.closeAnimationState.stop();
                }
            }
        }
    }

    private void coffinAnimationSetup() {
        if (this.getHealth() < 16.0f) {
            if (!this.getCoffinAnim() && this.getCoffinTick() < 171) {
                this.setCoffinAnim(true);
            }
            if (this.getCoffinAnim()) {
                this.setCoffinTick(this.getCoffinTick() + 1);
                if (this.getCoffinTick() == 101) {
                    for (int i = 0; i < 6; ++i) {
                        AbyssTechUtility.MobSimpleSpawn(this.level(), this.getOnPos().offset(this.random.nextInt(2) - 1, 0, this.random.nextInt(2) - 1), AbysstechEntities.HOMUNCULI.get().create(this.level()));
                    }
                }
                if (this.getCoffinTick() >= 172) {
                    this.setCoffinAnim(false);
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
            this.coffinAnimation();
            if (this.getCoffinTick() >= 92 && this.getCoffinTick() <= 105 && this.getCoffinAnim()) {
                int p = this.getCoffinTick() - 92;
                for (int i = 0; i < 8; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.SQUID_INK, this.getX() + (double)this.random.nextInt(4 + p * 2) - (double)(2 + p), this.getY() + (double)0.8f, this.getZ() + (double)this.random.nextInt(4 + p * 2) - (double)(2 + p), 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.level().isClientSide()) {
            this.coffinAnimationSetup();
            if (this.getCoffinAnim()) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 5, 10));
                this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 5, 10));
            }
            if (this.hasEffect(MobEffects.WITHER)) {
                this.removeEffect(MobEffects.WITHER);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(coffinTick, (Object)0);
        builder.define(coffinAnim, (Object)false);
    }

    public void setCoffinTick(int value) {
        this.entityData.set(coffinTick, (Object)value);
    }

    public int getCoffinTick() {
        return (Integer)this.entityData.get(coffinTick);
    }

    public void setCoffinAnim(boolean value) {
        this.entityData.set(coffinAnim, (Object)value);
    }

    public boolean getCoffinAnim() {
        return (Boolean)this.entityData.get(coffinAnim);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return AbyssTechSounds.CHATTER.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return AbyssTechSounds.MONSTER_SCREECH.get();
    }

    protected SoundEvent getDeathSound() {
        return AbyssTechSounds.MONSTER_DEATH_TWO.get();
    }
}

