/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.custom;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.sound.AbyssTechSounds;
import org.jetbrains.annotations.Nullable;

public class LadybugEntity
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState wingAnimationState = new AnimationState();
    private int entityTick = 0;
    private int idleAnimationTimeout = 0;
    private int wingAnimationTimeout = 0;

    public LadybugEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 12.0);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.wingAnimationTimeout >= 0) {
            --this.wingAnimationTimeout;
            if (this.wingAnimationTimeout <= 0) {
                this.wingAnimationState.stop();
            }
        }
    }

    public void tick() {
        super.tick();
        int n = this.entityTick = this.entityTick > 200 ? 0 : this.entityTick + 1;
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
            if (this.entityTick == 160) {
                this.wingAnimationState.start(this.tickCount);
            }
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return AbyssTechSounds.LADYBUG_WALK.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return AbyssTechSounds.LADYBUG_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return AbyssTechSounds.LADYBUG_DEATH.get();
    }
}

