/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechTags;
import org.jetbrains.annotations.Nullable;

public class SludgeSporeEntity
extends Monster
implements FlyingAnimal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState inflateAnimationState = new AnimationState();
    public final AnimationState deflateAnimationState = new AnimationState();
    public final AnimationState inflateHoldAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private int entityTick = 0;
    private int animateTick = 0;
    private boolean playerNear = false;
    private boolean animatePlayerNear = false;
    private int inflateTime = 0;
    private boolean inflated = false;
    private int animTick = 0;

    public SludgeSporeEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ARMOR, 1.0).add(Attributes.FLYING_SPEED, 0.35);
    }

    private void setupAnimationStates() {
        if (!this.animatePlayerNear) {
            if (!this.inflated && this.animTick <= 0) {
                if (this.idleAnimationTimeout <= 0) {
                    this.idleAnimationTimeout = 40;
                    this.idleAnimationState.start(this.tickCount);
                } else {
                    --this.idleAnimationTimeout;
                }
            } else {
                if (this.inflated) {
                    this.inflated = false;
                    this.animTick = 40;
                    this.inflateHoldAnimationState.stop();
                    this.deflateAnimationState.start(this.tickCount);
                }
                if (this.animTick == 1) {
                    this.deflateAnimationState.stop();
                }
                --this.animTick;
            }
        } else {
            if (!this.inflated) {
                this.inflated = true;
            }
            if (this.animTick == 0) {
                this.idleAnimationState.stop();
                this.inflateAnimationState.start(this.tickCount);
            }
            if (this.animTick == 10) {
                this.inflateAnimationState.stop();
                this.inflateHoldAnimationState.start(this.tickCount);
            }
            if (this.animTick >= 40) {
                this.inflateHoldAnimationState.start(this.tickCount);
                this.animTick = 11;
            }
            ++this.animTick;
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            ++this.entityTick;
            if (this.playerNear) {
                ++this.inflateTime;
            } else if (this.inflateTime > 0) {
                --this.inflateTime;
            }
            if (this.inflateTime >= 120) {
                BlockPos pos = new BlockPos((int)this.position().x, (int)this.position().y, (int)this.position().z);
                this.discard();
                this.spreadSludge(this.level(), pos);
            }
            if (this.entityTick == 10) {
                this.entityTick = 0;
                this.playerNear = this.checkPlayerNear(this.level());
            }
        }
        if (this.level().isClientSide()) {
            ++this.animateTick;
            if (this.animateTick == 10) {
                this.animateTick = 0;
                this.animatePlayerNear = this.checkPlayerNear(this.level());
            }
            this.setupAnimationStates();
        }
    }

    private boolean checkPlayerNear(Level level) {
        double searchRadius = 4.0;
        List players = level.getEntitiesOfClass(Player.class, new AABB(this.position().x - searchRadius, this.position().y - searchRadius, this.position().z - searchRadius, this.position().x + searchRadius, this.position().y + searchRadius, this.position().z + searchRadius));
        return !players.isEmpty();
    }

    private void spreadSludge(Level level, BlockPos pos) {
        level.playSound(null, pos, AbyssTechSounds.SPORE_POP.get(), SoundSource.BLOCKS);
        ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 8, 1.0, 1.0, 1.0, 0.0);
        double searchRadius = 4.0;
        List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(this.position().x - searchRadius, this.position().y - searchRadius, this.position().z - searchRadius, this.position().x + searchRadius, this.position().y + searchRadius, this.position().z + searchRadius));
        for (LivingEntity entity : entities) {
            entity.hurt(entity.damageSources().explosion(null), 5.0f);
        }
        for (int i = 0; i < 20; ++i) {
            BlockPos targetPos = pos.offset(this.random.nextInt(10) - 5, this.random.nextInt(10) - 5, this.random.nextInt(10) - 5);
            if (!level.getBlockState(targetPos).is(AbyssTechTags.Blocks.SLUDGE_SPREADABLE)) continue;
            level.setBlockAndUpdate(targetPos, ((Block)AbyssTechBlocks.OUTER_SLUDGE.get()).defaultBlockState());
        }
    }

    public boolean isFlying() {
        return true;
    }

    public boolean causeFallDamage(float distance, float multiplier, DamageSource source) {
        return false;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return AbyssTechSounds.SPORE_MOAN.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return AbyssTechSounds.SPORE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return AbyssTechSounds.SPORE_DEATH.get();
    }
}

