/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.entity.custom;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.sound.AbyssTechSounds;
import org.jetbrains.annotations.Nullable;

public class WanderingWispEntity
extends Animal
implements FlyingAnimal {
    public final AnimationState idleAnimationState = new AnimationState();
    private int entityTick = 0;
    private int idleAnimationTimeout = 0;

    public WanderingWispEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 6.0).add(Attributes.FLYING_SPEED, 0.3);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    public void tick() {
        super.tick();
        int n = this.entityTick = this.entityTick > 200 ? 0 : this.entityTick + 1;
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    public boolean isFlying() {
        return true;
    }

    public boolean causeFallDamage(float distance, float multiplier, DamageSource source) {
        return false;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return AbyssTechSounds.WISP_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return AbyssTechSounds.WISP_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return AbyssTechSounds.WISP_DEATH.get();
    }
}

