/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.event;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.quasar.abysstech.component.AbyssTechDataComponentTypes;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.item.custom.Mantra;
import net.quasar.abysstech.util.AbyssTechAttachmentType;
import net.quasar.abysstech.util.AbyssTechTags;

@EventBusSubscriber(modid="abysstech", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class AbyssTechClientEvents {
    private static final int yTranslation = 22;
    private static final int xTranslation = 4;
    private static final ResourceLocation STAIN_NONE = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_none.png");
    private static final ResourceLocation STAIN_TORPOR = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_torpor.png");
    private static final ResourceLocation STAIN_WEEPING = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_weeping.png");
    private static final ResourceLocation STAIN_GUT = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_gut.png");
    private static final ResourceLocation STAIN_MUSH = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_mush.png");
    private static final ResourceLocation STAIN_CREEPING = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_creeping.png");
    private static final ResourceLocation STAIN_SOL = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_sol.png");
    private static final ResourceLocation STAIN_VIBRANT = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_vibrant.png");
    private static final ResourceLocation STAIN_ROYAL = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_royal.png");
    private static final ResourceLocation ECHO_FLOURISHING = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_flourishing.png");
    private static final ResourceLocation ECHO_SANGUINE = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_sanguine.png");
    private static final ResourceLocation ECHO_STRANGE = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_strange.png");
    private static final ResourceLocation ECHO_MUNDANE = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_mundane.png");
    private static final ResourceLocation ECHO_INFERNAL = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_infernal.png");
    private static final ResourceLocation ECHO_EPHEMERAL = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_ephemeral.png");
    private static final ResourceLocation ECHO_DEEP = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_deep.png");
    private static final ResourceLocation ECHO_MAGIC = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_magic.png");
    private static final ResourceLocation ECHO_ALIEN = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_alien.png");
    private static final ResourceLocation ECHO_AVARICE = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_avarice.png");
    private static final ResourceLocation ECHO_MAD = ResourceLocation.fromNamespaceAndPath((String)"abysstech", (String)"textures/gui/icon/icon_echo_mad.png");

    @SubscribeEvent
    public static void placeholder_one(ComputeFovModifierEvent event) {
    }

    @SubscribeEvent
    public static void toolTipItemIconRender(RenderTooltipEvent.Color event) {
        AbyssTechClientEvents.itemRenderMantra(event);
        AbyssTechClientEvents.itemRenderAspects(event);
        if (AbyssTechClientEvents.shouldRenderEchos()) {
            AbyssTechClientEvents.itemRenderEchos(event);
        }
    }

    private static boolean shouldRenderEchos() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            return (Boolean)player.getData(AbyssTechAttachmentType.TOGGLE_ECHO_RENDER);
        }
        return false;
    }

    private static void itemRenderMantra(RenderTooltipEvent.Color event) {
        if (event.getItemStack().getItem() instanceof Mantra) {
            int iconX = event.getX() - 4;
            ItemStack eventItem = event.getItemStack();
            ResourceLocation[] stains = new ResourceLocation[]{STAIN_NONE, STAIN_TORPOR, STAIN_WEEPING, STAIN_GUT, STAIN_MUSH, STAIN_CREEPING, STAIN_SOL, STAIN_VIBRANT, STAIN_ROYAL};
            if (eventItem.get(AbyssTechDataComponentTypes.STAIN_TYPE) != null) {
                int[] stainData;
                for (int stain : stainData = new int[]{(Integer)eventItem.get(AbyssTechDataComponentTypes.STAIN_TYPE), (Integer)eventItem.get(AbyssTechDataComponentTypes.STAIN_SCENT), (Integer)eventItem.get(AbyssTechDataComponentTypes.STAIN_SATURATION)}) {
                    PoseStack poseStack = event.getGraphics().pose();
                    poseStack.pushPose();
                    poseStack.translate(0.0f, 0.0f, 500.0f);
                    event.getGraphics().blit(stains[stain], iconX, event.getY() - 22, 0.0f, 0.0f, 16, 16, 16, 16);
                    poseStack.popPose();
                    iconX += 18;
                }
            }
        }
    }

    private static void itemRenderAspects(RenderTooltipEvent.Color event) {
        if (event.getItemStack().is(AbyssTechTags.Items.HAS_ASPECT)) {
            Item[] aspectType = new Item[]{(Item)AbyssTechItems.SPROUTING_POWDER.get(), (Item)AbyssTechItems.DECAYING_POWDER.get(), (Item)AbyssTechItems.STRANGE_POWDER.get(), (Item)AbyssTechItems.DIAMOND_POWDER.get(), (Item)AbyssTechItems.CHRYSANTHEMUM_PASTE.get(), (Item)AbyssTechItems.RADIANT_OOZE.get(), (Item)AbyssTechItems.STYGIAN_OOZE.get(), (Item)AbyssTechItems.DAHLIA_PASTE.get()};
            Item[] aspectItem = new Item[]{(Item)AbyssTechItems.ICON_ROOTING.get(), (Item)AbyssTechItems.ICON_ROTTING.get(), (Item)AbyssTechItems.ICON_STRANGE.get(), (Item)AbyssTechItems.ICON_CORPOREAL.get(), (Item)AbyssTechItems.ICON_IMAGINARY.get(), (Item)AbyssTechItems.ICON_RADIANT.get(), (Item)AbyssTechItems.ICON_STYGIAN.get(), (Item)AbyssTechItems.ICON_CHANGING.get()};
            for (int i = 0; i < aspectType.length; ++i) {
                if (!event.getItemStack().is(aspectType[i])) continue;
                PoseStack poseStack = event.getGraphics().pose();
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 500.0f);
                event.getGraphics().renderFakeItem(aspectItem[i].getDefaultInstance(), (AbyssTechClientEvents.shouldRenderEchos() ? event.getX() + 18 : event.getX()) - 4, event.getY() - 22, 0);
                poseStack.popPose();
                break;
            }
        }
    }

    private static void itemRenderEchos(RenderTooltipEvent.Color event) {
        if (event.getItemStack().is(AbyssTechTags.Items.HAS_ECHO)) {
            List<TagKey> tags = List.of(AbyssTechTags.Items.HAS_FLOURISHING_ECHO, AbyssTechTags.Items.HAS_SANGUINE_ECHO, AbyssTechTags.Items.HAS_STRANGE_ECHO, AbyssTechTags.Items.HAS_MUNDANE_ECHO, AbyssTechTags.Items.HAS_INFERNAL_ECHO, AbyssTechTags.Items.HAS_EPHEMERAL_ECHO, AbyssTechTags.Items.HAS_DEEP_ECHO, AbyssTechTags.Items.HAS_MAGIC_ECHO, AbyssTechTags.Items.HAS_ALIEN_ECHO, AbyssTechTags.Items.HAS_AVARICE_ECHO, AbyssTechTags.Items.HAS_MAD_ECHO);
            ResourceLocation[] echoIcon = new ResourceLocation[]{ECHO_FLOURISHING, ECHO_SANGUINE, ECHO_STRANGE, ECHO_MUNDANE, ECHO_INFERNAL, ECHO_EPHEMERAL, ECHO_DEEP, ECHO_MAGIC, ECHO_ALIEN, ECHO_AVARICE, ECHO_MAD};
            for (int i = 0; i < tags.size(); ++i) {
                if (!event.getItemStack().is(tags.get(i))) continue;
                PoseStack poseStack = event.getGraphics().pose();
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, 500.0f);
                event.getGraphics().blit(echoIcon[i], event.getX() - 4, event.getY() - 22, 0.0f, 0.0f, 16, 16, 16, 16);
                poseStack.popPose();
                break;
            }
        }
    }
}

