/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.event;

import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.quasar.abysstech.block.entity.AbyssTechBlockEntities;
import net.quasar.abysstech.block.entity.custom.AbyssRFGenBlockEntity;
import net.quasar.abysstech.entity.AbysstechEntities;
import net.quasar.abysstech.entity.client.AbyssTechModelLayers;
import net.quasar.abysstech.entity.client.ChattererModel;
import net.quasar.abysstech.entity.client.HomunculiModel;
import net.quasar.abysstech.entity.client.HuggingSludgeModel;
import net.quasar.abysstech.entity.client.LadybugModel;
import net.quasar.abysstech.entity.client.SludgeSporeModel;
import net.quasar.abysstech.entity.client.WanderingWispModel;
import net.quasar.abysstech.entity.custom.ChattererEntity;
import net.quasar.abysstech.entity.custom.HomunculiEntity;
import net.quasar.abysstech.entity.custom.HuggingSludgeEntity;
import net.quasar.abysstech.entity.custom.LadybugEntity;
import net.quasar.abysstech.entity.custom.SludgeSporeEntity;
import net.quasar.abysstech.entity.custom.WanderingWispEntity;
import net.quasar.abysstech.util.AbyssTechUtility;

@EventBusSubscriber(modid="abysstech", bus=EventBusSubscriber.Bus.MOD)
public class AbyssTechEventBusEvents {
    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(AbyssTechModelLayers.LADYBUG, LadybugModel::createBodyLayer);
        event.registerLayerDefinition(AbyssTechModelLayers.WANDERINGWISP, WanderingWispModel::createBodyLayer);
        event.registerLayerDefinition(AbyssTechModelLayers.HUGGINGSLUDGE, HuggingSludgeModel::createBodyLayer);
        event.registerLayerDefinition(AbyssTechModelLayers.SLUDGE_SPORE, SludgeSporeModel::createBodyLayer);
        event.registerLayerDefinition(AbyssTechModelLayers.CHATTERER, ChattererModel::createBodyLayer);
        event.registerLayerDefinition(AbyssTechModelLayers.HOMUNCULI, HomunculiModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put(AbysstechEntities.LADYBUG.get(), LadybugEntity.createAttributes().build());
        event.put(AbysstechEntities.WANDERINGWISP.get(), WanderingWispEntity.createAttributes().build());
        event.put(AbysstechEntities.HUGGING_SLUDGE.get(), HuggingSludgeEntity.createAttributes().build());
        event.put(AbysstechEntities.SLUDGE_SPORE.get(), SludgeSporeEntity.createAttributes().build());
        event.put(AbysstechEntities.CHATTERER.get(), ChattererEntity.createAttributes().build());
        event.put(AbysstechEntities.HOMUNCULI.get(), HomunculiEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, AbyssTechBlockEntities.ABYSS_RF_GEN_BLOCK_ENTITY.get(), AbyssRFGenBlockEntity::getEnergyStorage);
    }

    @SubscribeEvent
    public static void registerSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        event.register(AbysstechEntities.SLUDGE_SPORE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, level, spawnType, pos, random) -> AbyssTechUtility.getThresholdIntegrity((Level)level, pos) >= 1000, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register(AbysstechEntities.CHATTERER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, level, spawnType, pos, random) -> AbyssTechUtility.getThresholdIntegrity((Level)level, pos) >= 800, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }
}

