/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.event;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.entity.custom.WanderingWispEntity;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.util.AbyssTechUtility;

@EventBusSubscriber(modid="abysstech", bus=EventBusSubscriber.Bus.GAME)
public class AbyssTechEvents {
    @SubscribeEvent
    public static void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AbyssTechItems.RAW_LIVELY_ABYSS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AbyssTechItems.RAW_VISCERAL_HEAP.get()}), new ItemStack((ItemLike)AbyssTechItems.SANGUINE_TEAR.get()));
        builder.addRecipe(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AbyssTechItems.RAW_VIBRANT_ABYSS.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AbyssTechItems.RAW_THRIVING_MUSH.get()}), new ItemStack((ItemLike)AbyssTechItems.FLOURISHING_TEAR.get()));
    }

    @SubscribeEvent
    public static void playerBottleWisp(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof WanderingWispEntity) {
            WanderingWispEntity wisp = (WanderingWispEntity)entity;
            Player player = event.getEntity();
            if (player.getMainHandItem().is(Items.GLASS_BOTTLE)) {
                wisp.discard();
                player.getMainHandItem().shrink(1);
                player.level().playSound(null, player.blockPosition(), SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.AMBIENT, 1.0f, 1.0f);
                AbyssTechUtility.ItemSimpleSpawn(player.level(), player.blockPosition(), AbyssTechBlocks.WISP_JAR.asItem());
            }
        }
    }

    @SubscribeEvent
    public static void moonScribe(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        if (player.getMainHandItem().is(AbyssTechItems.ABYSSAL_INK_BOTTLE)) {
            Item[] noteItem = new Item[]{(Item)AbyssTechItems.MOON_SCRIBE_THEORY.get(), (Item)AbyssTechItems.MOON_SCRIBE_VISION.get(), (Item)AbyssTechItems.MOON_SCRIBE_ABYSS.get(), (Item)AbyssTechItems.MOON_SCRIBE_TOME.get(), (Item)AbyssTechItems.MOON_SCRIBE_KEY.get()};
            for (int i = 0; i < noteItem.length - 1; ++i) {
                if (!player.getOffhandItem().is(noteItem[i])) continue;
                player.getMainHandItem().shrink(1);
                player.getOffhandItem().shrink(1);
                Level level = player.level();
                BlockPos pos = player.getOnPos();
                AbyssTechUtility.ItemSimpleSpawn(level, pos, noteItem[i + 1]);
                break;
            }
        }
    }
}

