/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.fluid;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.fluid.AbyssTechFluidTypes;
import net.quasar.abysstech.item.AbyssTechItems;

public class AbyssTechFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"abysstech");
    public static final Supplier<FlowingFluid> SOURCE_INK_FLUID = FLUIDS.register("source_ink_fluid", () -> new BaseFlowingFluid.Source(INK_FLUID_PROPERTIES));
    public static final Supplier<FlowingFluid> FLOWING_INK_FLUID = FLUIDS.register("flowing_ink_fluid", () -> new BaseFlowingFluid.Flowing(INK_FLUID_PROPERTIES));
    public static final DeferredBlock<LiquidBlock> INK_FLUID_BLOCK = AbyssTechBlocks.BLOCKS.register("ink_fluid_block", () -> new LiquidBlock(SOURCE_INK_FLUID.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noLootTable()));
    public static final DeferredItem<Item> INK_FLUID_BUCKET = AbyssTechItems.ITEMS.registerItem("ink_fluid_bucket", properties -> new BucketItem((Fluid)SOURCE_INK_FLUID.get(), properties.craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final BaseFlowingFluid.Properties INK_FLUID_PROPERTIES = new BaseFlowingFluid.Properties(AbyssTechFluidTypes.INK_FLUID_TYPE, SOURCE_INK_FLUID, FLOWING_INK_FLUID).slopeFindDistance(4).levelDecreasePerBlock(2).block(INK_FLUID_BLOCK).bucket(INK_FLUID_BUCKET);

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
    }
}

