/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.AbyssCropLike;
import net.quasar.abysstech.block.custom.SingleBoolCustomShapeBlock;
import net.quasar.abysstech.block.custom.TallCropLike;
import net.quasar.abysstech.effect.AbyssTechEffects;
import net.quasar.abysstech.entity.AbysstechEntities;
import net.quasar.abysstech.item.AbyssTechArmorMaterials;
import net.quasar.abysstech.item.AbyssTechFoodProperties;
import net.quasar.abysstech.item.AbyssTechToolTiers;
import net.quasar.abysstech.item.custom.CreativeWand;
import net.quasar.abysstech.item.custom.CrystalPrepKit;
import net.quasar.abysstech.item.custom.DrinkAnimItem;
import net.quasar.abysstech.item.custom.FuelItem;
import net.quasar.abysstech.item.custom.GuideBook;
import net.quasar.abysstech.item.custom.InstabilityDetector;
import net.quasar.abysstech.item.custom.JarRelocator;
import net.quasar.abysstech.item.custom.Lacquer;
import net.quasar.abysstech.item.custom.LootBag;
import net.quasar.abysstech.item.custom.Mantra;
import net.quasar.abysstech.item.custom.MortBlend;
import net.quasar.abysstech.item.custom.MortKnife;
import net.quasar.abysstech.item.custom.MortTuningWand;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechToolUtility;
import net.quasar.abysstech.util.AbyssTechUtility;

public class AbyssTechItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"abysstech");
    public static final DeferredItem<Item> MORT_BRICK = ITEMS.register("mort_brick", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MORT_BLEND = ITEMS.register("mort_blend", () -> new MortBlend(new Item.Properties()));
    public static final DeferredItem<Item> RAW_LIVELY_ABYSS = ITEMS.register("raw_lively_abyss", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> RAW_VIBRANT_ABYSS = ITEMS.register("raw_vibrant_abyss", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> RAW_THRIVING_MUSH = ITEMS.register("raw_thriving_mush", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> RAW_VISCERAL_HEAP = ITEMS.register("raw_visceral_heap", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> FLOURISHING_TEAR = ITEMS.register("flourishing_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SANGUINE_TEAR = ITEMS.register("sanguine_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> STRANGE_TEAR = ITEMS.register("strange_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MUNDANE_TEAR = ITEMS.register("mundane_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> INFERNAL_TEAR = ITEMS.register("infernal_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> EPHEMERAL_TEAR = ITEMS.register("ephemeral_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DEEP_TEAR = ITEMS.register("deep_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MAGIC_TEAR = ITEMS.register("magic_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ALIEN_TEAR = ITEMS.register("alien_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> AVARICE_TEAR = ITEMS.register("avarice_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MAD_TEAR = ITEMS.register("mad_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> FLOURISHING_RESIDUE = ITEMS.register("flourishing_residue", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SANGUINE_RESIDUE = ITEMS.register("sanguine_residue", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> VIBRANT_INGOT = ITEMS.register("vibrant_ingot", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> VIBRANT_NUGGET = ITEMS.register("vibrant_nugget", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LIVELY_INGOT = ITEMS.register("lively_ingot", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LIVELY_NUGGET = ITEMS.register("lively_nugget", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> BOUNDARY_GEM = ITEMS.register("boundary_gem", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ROOTING_GEM = ITEMS.register("rooting_gem", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ROTTING_GEM = ITEMS.register("rotting_gem", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> FADED_TEAR = ITEMS.register("faded_tear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> FADED_TEAR_POWDER = ITEMS.register("faded_tear_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_STARTER_PURPLE = ITEMS.register("crystal_starter_purple", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_STARTER_LIME = ITEMS.register("crystal_starter_lime", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_STARTER_YELLOW = ITEMS.register("crystal_starter_yellow", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_STARTER_SKY = ITEMS.register("crystal_starter_sky", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_STARTER_BLUE = ITEMS.register("crystal_starter_blue", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_STARTER_RED = ITEMS.register("crystal_starter_red", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_STARTER_PINK = ITEMS.register("crystal_starter_pink", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CRYSTAL_LATTICE = ITEMS.register("crystal_lattice", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> STYGIAN_OOZE = ITEMS.register("stygian_ooze", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DECAYING_POWDER = ITEMS.register("decaying_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SPROUTING_POWDER = ITEMS.register("sprouting_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> STRANGE_POWDER = ITEMS.register("strange_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CHRYSANTHEMUM_PASTE = ITEMS.register("chrysanthemum_paste", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> RADIANT_OOZE = ITEMS.register("radiant_ooze", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DIAMOND_POWDER = ITEMS.register("diamond_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DAHLIA_PASTE = ITEMS.register("dahlia_paste", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ABYSSAL_GEAR = ITEMS.register("abyssal_gear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> TUNED_ABYSSAL_GEAR = ITEMS.register("tuned_abyssal_gear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> THRESHOLD_GEAR = ITEMS.register("threshold_gear", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ABYSSAL_INK_BOTTLE = ITEMS.register("abyssal_ink_bottle", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> PARCHMENT = ITEMS.register("parchment", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> RESIN = ITEMS.register("resin", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> LACQUER = ITEMS.register("lacquer", () -> new Lacquer(new Item.Properties()));
    public static final DeferredItem<Item> DREAMING_CRYSTAL_POWDER = ITEMS.register("dreaming_crystal_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> REM_POWDER = ITEMS.register("rem_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MISSING_CHAPTER = ITEMS.registerItem("missing_chapter", properties -> new Item((Item.Properties)properties){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.missing_chapter.tooltip.1"));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }, new Item.Properties());
    public static final DeferredItem<Item> SCRUBBER_FILTER = ITEMS.register("scrubber_filter", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ABYSSAL_SLUDGE = ITEMS.register("abyssal_sludge", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> STRANGE_COMB = ITEMS.register("strange_comb", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> VIBRANT_WHEAT = ITEMS.register("vibrant_wheat", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> TORPOR_SPORES = ITEMS.register("torpor_spores", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> EIDOLON_POWDER = ITEMS.register("eidolon_powder", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SOULFUL_DUST = ITEMS.register("soulful_dust", () -> new Item(new Item.Properties()){

        public InteractionResult useOn(UseOnContext context) {
            BlockState state;
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            if (!level.isClientSide() && (state = level.getBlockState(pos)).is(AbyssTechBlocks.CORPSE_PETAL_CROP) && !((Boolean)state.getValue((Property)AbyssCropLike.SPECIAL)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AbyssCropLike.SPECIAL, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS);
                context.getItemInHand().shrink(1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
    });
    public static final DeferredItem<Item> MOON_SCRIBE_THEORY = ITEMS.registerItem("moon_scribe_theory", properties -> new Item((Item.Properties)properties){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_theory.tooltip.1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_theory.tooltip.2"));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }, new Item.Properties());
    public static final DeferredItem<Item> MOON_SCRIBE_VISION = ITEMS.registerItem("moon_scribe_vision", properties -> new Item((Item.Properties)properties){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_vision.tooltip.1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_vision.tooltip.2"));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }, new Item.Properties());
    public static final DeferredItem<Item> MOON_SCRIBE_ABYSS = ITEMS.registerItem("moon_scribe_abyss", properties -> new Item((Item.Properties)properties){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_abyss.tooltip.1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_abyss.tooltip.2"));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }, new Item.Properties());
    public static final DeferredItem<Item> MOON_SCRIBE_TOME = ITEMS.registerItem("moon_scribe_tome", properties -> new Item((Item.Properties)properties){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_tome.tooltip.1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_tome.tooltip.2"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_tome.tooltip.3"));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }, new Item.Properties());
    public static final DeferredItem<Item> MOON_SCRIBE_KEY = ITEMS.registerItem("moon_scribe_key", properties -> new Item((Item.Properties)properties){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_key.tooltip.1"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_key.tooltip.2"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_key.tooltip.3"));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.moon_scribe_key.tooltip.4"));
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }, new Item.Properties());
    public static final DeferredItem<Item> RAW_MEMORY_MELD = ITEMS.register("raw_memory_meld", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> REFINED_MEMORY_MELD = ITEMS.register("refined_memory_meld", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> RAW_VERDANT_METAL = ITEMS.register("raw_verdant_metal", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> VERDANT_INGOT = ITEMS.register("verdant_ingot", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> RAW_GRAVE_METAL = ITEMS.register("raw_grave_metal", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> GRAVE_INGOT = ITEMS.register("grave_ingot", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ABYSSAL_GEM = ITEMS.register("abyssal_gem", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> PRIMORDIAL_INGOT = ITEMS.register("primordial_ingot", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> TOUGH_MORT_ROD = ITEMS.register("tough_mort_rod", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MELD_CORE = ITEMS.register("meld_core", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ABYSSAL_GEODE = ITEMS.register("abyssal_geode", () -> new LootBag(new Item.Properties()));
    public static final DeferredItem<Item> DREAMING_BAG = ITEMS.register("dreaming_bag", () -> new LootBag(new Item.Properties()));
    public static final DeferredItem<Item> TORPOR_CAP_FERMENTED = ITEMS.register("torpor_cap_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> WEEPING_CAP_FERMENTED = ITEMS.register("weeping_cap_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ROYAL_HONEY_FERMENTED = ITEMS.register("royal_honey_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> VIBRANT_WHEAT_FERMENTED = ITEMS.register("vibrant_wheat_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SOL_MOREL_FERMENTED = ITEMS.register("sol_morel_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CREEPING_MOREL_FERMENTED = ITEMS.register("creeping_morel_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> GUT_PUFFBALL_FERMENTED = ITEMS.register("gut_puffball_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MUSH_PUFFBALL_FERMENTED = ITEMS.register("mush_puffball_fermented", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_VIBRANT = ITEMS.register("distillate_vibrant", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_ROYAL = ITEMS.register("distillate_royal", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_SOL = ITEMS.register("distillate_sol", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_CREEPING = ITEMS.register("distillate_creeping", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_GUT = ITEMS.register("distillate_gut", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_MUSH = ITEMS.register("distillate_mush", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_TORPOR = ITEMS.register("distillate_torpor", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> DISTILLATE_WEEPING = ITEMS.register("distillate_weeping", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ABYSSAL_ESSENCE_AMPOULE = ITEMS.register("abyssal_essence_ampoule", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ALCHEMISTS_DOUGH = ITEMS.register("alchemists_dough", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MISCHIEVOUS_DOUGH = ITEMS.register("mischievous_dough", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SUNLIGHT_DROP = ITEMS.register("sunlight_drop", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> SUNLIGHT_BAR = ITEMS.register("sunlight_bar", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> AVARICE_PEBBLE = ITEMS.register("avarice_pebble", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> AVARICE_CHUNK = ITEMS.register("avarice_chunk", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MIMIGELL = ITEMS.register("mimigell", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> COMPACT_MIMIGELL = ITEMS.register("compact_mimigell", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> GUIDE_BOOK = ITEMS.register("guide_book", () -> new GuideBook(new Item.Properties()));
    public static final DeferredItem<Item> SOMBER_AMARANTH = ITEMS.register("somber_amaranth", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> VOID_PIECE = ITEMS.register("void_piece", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> FLEMON_RIND = ITEMS.register("flemon_rind", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MILKY_TINCTURE = ITEMS.registerItem("milky_tincture", properties -> new DrinkAnimItem((Item.Properties)properties){

        public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
            if (!level.isClientSide()) {
                livingEntity.removeAllEffects();
            }
            return super.finishUsingItem(stack, level, livingEntity);
        }
    }, new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD));
    public static final DeferredItem<Item> GLOW_JUICE = ITEMS.registerItem("glow_juice", properties -> new DrinkAnimItem((Item.Properties)properties){

        public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
            if (!level.isClientSide()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0));
                livingEntity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 320, 0));
            }
            return super.finishUsingItem(stack, level, livingEntity);
        }
    }, new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD));
    public static final DeferredItem<Item> EARTHY_BROTH = ITEMS.register("earthy_broth", () -> new DrinkAnimItem(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FULFILLING)));
    public static final DeferredItem<Item> SOUR_NECTAR = ITEMS.register("sour_nectar", () -> new DrinkAnimItem(new Item.Properties().food(AbyssTechFoodProperties.LARGE_UNFULFILLING)));
    public static final DeferredItem<Item> SWEET_AMBROSIA = ITEMS.registerItem("sweet_ambrosia", properties -> new DrinkAnimItem((Item.Properties)properties){

        public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
            if (!level.isClientSide()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0));
            }
            return super.finishUsingItem(stack, level, livingEntity);
        }
    }, new Item.Properties().food(AbyssTechFoodProperties.LARGE_FOOD));
    public static final DeferredItem<Item> JUNIPER_BERRIES = ITEMS.register("juniper_berries", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD)));
    public static final DeferredItem<Item> JUNIPER_BERRIES_EI = ITEMS.register("juniper_berries_ei", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.NORM_FOOD)));
    public static final DeferredItem<Item> HONEY_DROP = ITEMS.register("honey_drop", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD)));
    public static final DeferredItem<Item> ROYAL_HONEY_DROP = ITEMS.register("royal_honey_drop", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD)));
    public static final DeferredItem<Item> LIVELY_APPLE = ITEMS.register("lively_apple", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.NORM_FOOD)));
    public static final DeferredItem<Item> LIVELY_CARAMEL_APPLE = ITEMS.register("lively_caramel_apple", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.NORM_MID_FOOD)));
    public static final DeferredItem<Item> CHEESE = ITEMS.register("cheese", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD)));
    public static final DeferredItem<Item> SOMBER_BREAD = ITEMS.register("somber_bread", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_NORM_FOOD)));
    public static final DeferredItem<Item> ABYSSAL_MUSHROOM_STEW = ITEMS.register("abyssal_mushroom_stew", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.NORM_FOOD)));
    public static final DeferredItem<Item> ABYSSAL_SALAD = ITEMS.register("abyssal_salad", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.NORM_FOOD)));
    public static final DeferredItem<Item> FLEMON_SLICE = ITEMS.register("flemon_slice", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD)));
    public static final DeferredItem<Item> MOURD_SLICE = ITEMS.register("mourd_slice", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FOOD)));
    public static final DeferredItem<Item> GUURANGE_SLICE = ITEMS.register("guurange_slice", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.SMALL_FULFILLING)));
    public static final DeferredItem<Item> ABYSSAL_STEW = ITEMS.register("abyssal_stew_bowl", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.MID_FOOD)){

        public int getMaxStackSize(ItemStack stack) {
            return 8;
        }
    });
    public static final DeferredItem<Item> ABYSSAL_STEW_HOT = ITEMS.register("abyssal_stew_bowl_hot", () -> new Item(new Item.Properties().food(AbyssTechFoodProperties.MID_LARGE_FOOD)){

        public int getMaxStackSize(ItemStack stack) {
            return 8;
        }
    });
    public static final DeferredItem<Item> ABYSS_BULB_SEED = ITEMS.register("abyss_bulb_seed", () -> new ItemNameBlockItem((Block)AbyssTechBlocks.ABYSS_BULB_CROP.get(), new Item.Properties()));
    public static final DeferredItem<Item> CORPSE_PETAL_SEED = ITEMS.register("corpse_petal_seed", () -> new ItemNameBlockItem((Block)AbyssTechBlocks.CORPSE_PETAL_CROP.get(), new Item.Properties()));
    public static final DeferredItem<Item> SOMBER_AMARANTH_SEED = ITEMS.register("somber_amaranth_seed", () -> new ItemNameBlockItem((Block)AbyssTechBlocks.SOMBER_AMARANTH_CROP.get(), new Item.Properties()){

        public InteractionResult useOn(UseOnContext context) {
            TallCropLike tallCropLike;
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            Block block = this.getBlock();
            if (context.getClickedFace() == Direction.UP && level.getBlockState(pos.above(1)).isAir() && level.getBlockState(pos.above(2)).isAir() && block instanceof TallCropLike && (tallCropLike = (TallCropLike)block).survive((LevelReader)level, pos.above(1))) {
                tallCropLike.place(level, block.defaultBlockState(), pos.above(1));
                level.playSound(null, pos, block.defaultBlockState().getSoundType((LevelReader)level, pos, null).getPlaceSound(), SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
    });
    public static final DeferredItem<Item> ANTHRACITE = ITEMS.registerItem("anthracite", properties -> new FuelItem((Item.Properties)properties, 4800), new Item.Properties());
    public static final DeferredItem<Item> MORT_TUNING_WAND = ITEMS.register("mort_tuning_wand", () -> new MortTuningWand(new Item.Properties().durability(128)));
    public static final DeferredItem<Item> CRYSTAL_PREP_KIT = ITEMS.register("crystal_prep_kit", () -> new CrystalPrepKit(new Item.Properties().durability(128)));
    public static final DeferredItem<Item> JAR_RELOCATOR = ITEMS.register("jar_relocator", () -> new JarRelocator(new Item.Properties().stacksTo(1)));
    public static final DeferredItem<Item> MORT_KNIFE = ITEMS.register("mort_knife", () -> new MortKnife(new Item.Properties().durability(64)));
    public static final DeferredItem<Item> INSTABILITY_DETECTOR = ITEMS.register("instability_detector", () -> new InstabilityDetector(new Item.Properties()));
    public static final DeferredItem<Item> VIBRANT_PICKAXE = ITEMS.register("vibrant_pickaxe", () -> new PickaxeItem(AbyssTechToolTiers.VIBRANT, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)AbyssTechToolTiers.VIBRANT, (float)1.0f, (float)-2.8f))){

        public boolean mineBlock(ItemStack itemstack, Level level, BlockState blockstate, BlockPos pos, LivingEntity entity) {
            if (!level.isClientSide()) {
                AbyssTechToolUtility.toolDropSpecialItem(level, pos, (TagKey<Block>)BlockTags.STONE_ORE_REPLACEABLES, RAW_THRIVING_MUSH.asItem(), 16);
            }
            return super.mineBlock(itemstack, level, blockstate, pos, entity);
        }
    });
    public static final DeferredItem<Item> VIBRANT_SWORD = ITEMS.register("vibrant_sword", () -> new SwordItem(AbyssTechToolTiers.VIBRANT, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.VIBRANT, (int)4, (float)-2.4f))));
    public static final DeferredItem<Item> LIVELY_PICKAXE = ITEMS.register("lively_pickaxe", () -> new PickaxeItem(AbyssTechToolTiers.LIVELY, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)AbyssTechToolTiers.LIVELY, (float)1.0f, (float)-2.8f))){

        public boolean mineBlock(ItemStack itemstack, Level level, BlockState blockstate, BlockPos pos, LivingEntity entity) {
            if (!level.isClientSide()) {
                AbyssTechToolUtility.toolDropSpecialItem(level, pos, (TagKey<Block>)BlockTags.STONE_ORE_REPLACEABLES, RAW_VISCERAL_HEAP.asItem(), 16);
            }
            return super.mineBlock(itemstack, level, blockstate, pos, entity);
        }
    });
    public static final DeferredItem<Item> LIVELY_AXE = ITEMS.register("lively_axe", () -> new AxeItem(AbyssTechToolTiers.LIVELY, new Item.Properties().attributes(AxeItem.createAttributes((Tier)AbyssTechToolTiers.LIVELY, (float)6.0f, (float)-3.2f))));
    public static final DeferredItem<Item> BLEEDING_SHOVEL = ITEMS.register("bleeding_shovel", () -> new ShovelItem(AbyssTechToolTiers.LIVELY, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)AbyssTechToolTiers.LIVELY, (float)1.0f, (float)-2.0f))));
    public static final DeferredItem<Item> MOSSY_HOE = ITEMS.register("mossy_hoe", () -> new HoeItem(AbyssTechToolTiers.VIBRANT, new Item.Properties().attributes(HoeItem.createAttributes((Tier)AbyssTechToolTiers.VIBRANT, (float)1.0f, (float)-1.0f))));
    public static final DeferredItem<Item> BARK_GEM_HOE = ITEMS.register("bark_gem_hoe", () -> new HoeItem(AbyssTechToolTiers.ROOTING, new Item.Properties().attributes(HoeItem.createAttributes((Tier)AbyssTechToolTiers.ROOTING, (float)1.0f, (float)-1.0f))));
    public static final DeferredItem<Item> BOUNDARY_PICKAXE = ITEMS.register("boundary_pickaxe", () -> new PickaxeItem(AbyssTechToolTiers.BOUNDARY, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)AbyssTechToolTiers.BOUNDARY, (float)2.0f, (float)-2.0f))){

        public boolean mineBlock(ItemStack itemstack, Level level, BlockState blockstate, BlockPos pos, LivingEntity entity) {
            if (!level.isClientSide()) {
                AbyssTechToolUtility.toolDropBonusMined(level, pos, (TagKey<Block>)BlockTags.STONE_ORE_REPLACEABLES, 16, 1, 5);
            }
            return super.mineBlock(itemstack, level, blockstate, pos, entity);
        }
    });
    public static final DeferredItem<Item> PROSPECTORS_PICK = ITEMS.register("prospectors_pick", () -> new PickaxeItem(AbyssTechToolTiers.BOUNDARY, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)AbyssTechToolTiers.BOUNDARY, (float)2.0f, (float)-2.0f))){

        public InteractionResult useOn(UseOnContext context) {
            int r;
            List<BlockPos> blockPos;
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            if (!(level.isClientSide() || player == null || player.hasEffect(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT) || (blockPos = AbyssTechUtility.getBlocksPosInCube(level, pos, r = player.isShiftKeyDown() ? 8 : 16, AbyssTechTags.Blocks.PROSPECT_DETECT, true)).isEmpty())) {
                player.addEffect(new MobEffectInstance(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT, 100, 0));
                level.playSound(null, pos, AbyssTechSounds.KNIFE_HIT.get(), SoundSource.BLOCKS);
                player.displayClientMessage((Component)Component.literal((String)(level.getBlockState(blockPos.getFirst()).getBlock().getName().getString() + ": " + AbyssTechUtility.getDistOfTwoTargets(blockPos.getFirst(), pos) + " blocks away.")), true);
            }
            return InteractionResult.SUCCESS;
        }
    });
    public static final DeferredItem<Item> MORT_DAGGER = ITEMS.register("mort_dagger", () -> new SwordItem(AbyssTechToolTiers.BOUNDARY, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.BOUNDARY, (int)3, (float)-1.0f))){

        public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
            if (!level.isClientSide() && !player.hasEffect(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT)) {
                level.playSound(null, player.getOnPos(), SoundEvents.ENDER_DRAGON_FLAP, SoundSource.BLOCKS, 1.0f, 2.0f);
                player.jumpFromGround();
                player.setDeltaMovement(player.getDeltaMovement().x() * 6.0, player.getDeltaMovement().y(), player.getDeltaMovement().z() * 6.0);
                player.addEffect(new MobEffectInstance(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT, 40, 0));
                AbyssTechUtility.syncMovement(player);
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
    });
    public static final DeferredItem<Item> GRAVE_BELL = ITEMS.register("grave_bell", () -> new SwordItem(AbyssTechToolTiers.BOUNDARY, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.BOUNDARY, (int)7, (float)-3.0f))){
        final Random random = new Random();

        public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
            Level level = player.level();
            if (!level.isClientSide()) {
                level.playSound(null, player.blockPosition(), SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 1.0f, this.random.nextFloat(2.0f));
            }
            return super.onLeftClickEntity(stack, player, entity);
        }

        public InteractionResult useOn(UseOnContext context) {
            Level level = context.getLevel();
            BlockPos pos = context.getClickedPos();
            Player player = context.getPlayer();
            if (!(level.isClientSide() || player == null || level.getBlockState(context.getClickedPos()).isAir() || player.hasEffect(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT))) {
                List<Monster> mobToMove = AbyssTechUtility.getEntitiesInArea(level, pos, Monster.class, 5);
                for (Monster monster : mobToMove) {
                    monster.setDeltaMovement(monster.getDeltaMovement().add(Math.signum(monster.getX() - (double)pos.getX()) * 0.9, 1.0, Math.signum(monster.getZ() - (double)pos.getZ()) * 0.9));
                }
                player.addEffect(new MobEffectInstance(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT, 40, 0));
                ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, level.getBlockState(pos)), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 40, 1.0, 0.5, 1.0, (double)0.05f);
                level.playSound(null, pos, AbyssTechSounds.GRAVE_BELL_IMPACT.get(), SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
    });
    public static final DeferredItem<Item> GRAVEL_BALL = ITEMS.register("gravel_ball", () -> new ShovelItem(AbyssTechToolTiers.BOUNDARY, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)AbyssTechToolTiers.BOUNDARY, (float)1.0f, (float)-2.0f))){

        public InteractionResult useOn(UseOnContext context) {
            Level level = context.getLevel();
            Player player = context.getPlayer();
            if (!level.isClientSide() && player != null) {
                BlockPos pos = player.getOnPos().above(1);
                boolean empowered = AbyssTechUtility.SearchAndTakeEssence(level, pos, 12, 5);
                int searchRadius = 8;
                for (int x = -searchRadius; x <= searchRadius; ++x) {
                    for (int y = -searchRadius; y <= searchRadius; ++y) {
                        for (int z = -searchRadius; z <= searchRadius; ++z) {
                            BlockPos tarBlockPos = pos.offset(x, y, z);
                            if (!level.getBlockState(tarBlockPos).is(Blocks.GRAVEL)) continue;
                            level.setBlockAndUpdate(tarBlockPos, empowered ? Blocks.TUFF.defaultBlockState() : Blocks.STONE.defaultBlockState());
                        }
                    }
                }
                level.playSound(null, pos, AbyssTechSounds.ARTIFACT_STRANGE.get(), SoundSource.BLOCKS);
                AbyssTechUtility.SimpleDamageHeldItem(level, pos, player, GRAVEL_BALL.asItem());
            }
            return InteractionResult.SUCCESS;
        }
    });
    public static final DeferredItem<Item> RADIANT_MARK = ITEMS.register("radiant_mark", () -> new Item(new Item.Properties()){
        final Random random = new Random();

        public InteractionResult useOn(UseOnContext context) {
            Level level = context.getLevel();
            Player player = context.getPlayer();
            if (!level.isClientSide() && player != null) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    if (!player.getInventory().getItem(i).is(AbyssTechTags.Items.RADIANT_MARK_CAN_USE)) continue;
                    BlockPos tPos = AbyssTechUtility.getOffsetPosFromFace(context.getClickedPos(), context.getClickedFace(), 1);
                    if (level.getBlockState(tPos).isAir()) {
                        if ((player.getInventory().getItem(i).is(Items.COAL) || player.getInventory().getItem(i).is(Items.CHARCOAL) ? this.random.nextInt(3) : 1) == 1) {
                            player.getInventory().getItem(i).shrink(1);
                        }
                        level.setBlockAndUpdate(tPos, AbyssTechUtility.SearchAndTakeEssence(level, player.getOnPos().above(1), 12, 2) ? (BlockState)((Block)AbyssTechBlocks.GLOWING_SPARK.get()).defaultBlockState().setValue((Property)SingleBoolCustomShapeBlock.boolState, (Comparable)Boolean.valueOf(true)) : ((Block)AbyssTechBlocks.GLOWING_SPARK.get()).defaultBlockState());
                        level.playSound(null, tPos, AbyssTechSounds.SMALL_FLAME.get(), SoundSource.BLOCKS);
                        return InteractionResult.SUCCESS;
                    }
                    player.displayClientMessage((Component)Component.literal((String)"Cant place spark there."), true);
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.literal((String)"Torches or Coal Required."), true);
            }
            return InteractionResult.SUCCESS;
        }
    });
    public static final DeferredItem<Item> WITHERLESS_MACE = ITEMS.register("witherless_mace", () -> new SwordItem(AbyssTechToolTiers.BOUNDARY, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.BOUNDARY, (int)4, (float)-3.0f))){

        public InteractionResult useOn(UseOnContext context) {
            Level level = context.getLevel();
            BlockPos clickedPos = context.getClickedPos();
            if (!level.isClientSide() && level.getBlockState(clickedPos).is(Blocks.GLASS)) {
                level.setBlockAndUpdate(clickedPos, ((Block)AbyssTechBlocks.WITHERLESS_GLASS.get()).defaultBlockState());
                level.playSound(null, clickedPos, SoundEvents.MACE_SMASH_AIR, SoundSource.BLOCKS, 1.0f, 2.0f);
            }
            return InteractionResult.SUCCESS;
        }

        public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
            if (!player.level().isClientSide() && entity.getType().is(EntityTypeTags.UNDEAD)) {
                entity.hurt(entity.damageSources().magic(), 10.0f);
            }
            return super.onLeftClickEntity(stack, player, entity);
        }
    });
    public static final DeferredItem<Item> SCARLET_HARVEST = ITEMS.register("scarlet_harvest", () -> new HoeItem(AbyssTechToolTiers.BOUNDARY, new Item.Properties().attributes(HoeItem.createAttributes((Tier)AbyssTechToolTiers.BOUNDARY, (float)2.5f, (float)-1.4f))){
        final Random random = new Random();

        public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
            if (!player.level().isClientSide() && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (player.hasEffect(AbyssTechEffects.SCARLET_EFFECT) && this.random.nextInt(5) == 1) {
                    Item[] specialDrop = new Item[]{AbyssTechBlocks.FRESH_HEART.asItem(), AbyssTechBlocks.FRESH_LUNG.asItem(), AbyssTechBlocks.FRESH_GUTS.asItem(), AbyssTechBlocks.FRESH_EYES.asItem()};
                    entity.hurt(entity.damageSources().playerAttack(player), 2.0f);
                    AbyssTechUtility.ItemSimpleSpawn(player.level(), livingEntity.getOnPos(), specialDrop[this.random.nextInt(specialDrop.length)]);
                }
            }
            return super.onLeftClickEntity(stack, player, entity);
        }

        public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
            if (!(level.isClientSide() || player.hasEffect(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT) || player.hasEffect(AbyssTechEffects.SCARLET_EFFECT))) {
                player.addEffect(new MobEffectInstance(AbyssTechEffects.SCARLET_EFFECT, 160, 0));
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
    });
    public static final DeferredItem<Item> STRANGE_BEACON = ITEMS.register("strange_beacon", () -> new Item(new Item.Properties()){

        public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
            if (!level.isClientSide() && !player.hasEffect(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT) && AbyssTechUtility.SearchAndTakeEssence(level, player.getOnPos().above(2), 16, 5)) {
                player.addEffect(new MobEffectInstance(AbyssTechEffects.ABILITY_COOLDOWN_EFFECT, 30, 0));
                BlockPos collidedPos = player.getOnPos().above(2);
                for (int i = 0; i < 20; ++i) {
                    Vec3 targetPos = player.getEyePosition().add(player.getLookAngle().scale((double)i));
                    collidedPos = new BlockPos((int)targetPos.x, (int)targetPos.y, (int)targetPos.z);
                    if (!level.getBlockState(collidedPos).isAir()) break;
                    List<Monster> monsters = AbyssTechUtility.getEntitiesInArea(level, collidedPos, Monster.class, 1);
                    for (Monster monster : monsters) {
                        monster.hurt(monster.damageSources().magic(), 16.0f);
                    }
                }
                AbyssTechUtility.drawPathToTarget(level, player.getOnPos().above(2), collidedPos, 0.06f, AbyssTechParticles.SPARKLE_NORM.get());
                level.playSound(null, player.getOnPos(), AbyssTechSounds.COIL_FIRE.get(), SoundSource.PLAYERS, 1.0f, 2.0f);
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
    });
    public static final DeferredItem<Item> MELD_PICKAXE = ITEMS.register("meld_pickaxe", () -> new PickaxeItem(AbyssTechToolTiers.MELD, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)AbyssTechToolTiers.MELD, (float)1.0f, (float)-2.0f))));
    public static final DeferredItem<Item> BONE_GEM_AXE = ITEMS.register("bone_gem_axe", () -> new AxeItem(AbyssTechToolTiers.ROTTING, new Item.Properties().attributes(AxeItem.createAttributes((Tier)AbyssTechToolTiers.ROTTING, (float)7.0f, (float)-3.0f))){

        public boolean mineBlock(ItemStack itemstack, Level level, BlockState blockstate, BlockPos pos, LivingEntity entity) {
            if (!level.isClientSide()) {
                AbyssTechToolUtility.toolDropBonusMined(level, pos, (TagKey<Block>)BlockTags.LOGS, 30, 1, 5);
            }
            return super.mineBlock(itemstack, level, blockstate, pos, entity);
        }
    });
    public static final DeferredItem<Item> MELD_AXE = ITEMS.register("meld_axe", () -> new AxeItem(AbyssTechToolTiers.MELD, new Item.Properties().attributes(AxeItem.createAttributes((Tier)AbyssTechToolTiers.MELD, (float)7.0f, (float)-3.2f))));
    public static final DeferredItem<Item> BARK_GEM_SWORD = ITEMS.register("bark_gem_sword", () -> new SwordItem(AbyssTechToolTiers.ROOTING, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.ROOTING, (int)5, (float)-2.5f))){
        final Random random = new Random();

        public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
            Level level = player.level();
            if (!level.isClientSide() && level.getBlockState(player.getOnPos()).is(BlockTags.DIRT) && level.canSeeSky(player.getOnPos().above(1)) && this.random.nextInt(8) < 1) {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 60, 0));
            }
            return super.onLeftClickEntity(stack, player, entity);
        }
    });
    public static final DeferredItem<Item> MELD_SWORD = ITEMS.register("meld_sword", () -> new SwordItem(AbyssTechToolTiers.MELD, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.MELD, (int)5, (float)-2.4f))));
    public static final DeferredItem<Item> BONE_GEM_SHOVEL = ITEMS.register("bone_gem_shovel", () -> new ShovelItem(AbyssTechToolTiers.ROTTING, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)AbyssTechToolTiers.ROTTING, (float)1.0f, (float)-2.0f))));
    public static final DeferredItem<Item> MELD_SHOVEL = ITEMS.register("meld_shovel", () -> new ShovelItem(AbyssTechToolTiers.MELD, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)AbyssTechToolTiers.MELD, (float)1.0f, (float)-2.0f))));
    public static final DeferredItem<Item> MELD_HOE = ITEMS.register("meld_hoe", () -> new HoeItem(AbyssTechToolTiers.MELD, new Item.Properties().attributes(HoeItem.createAttributes((Tier)AbyssTechToolTiers.MELD, (float)1.0f, (float)-1.0f))));
    public static final DeferredItem<Item> VERDANT_PICKAXE = ITEMS.register("verdant_pickaxe", () -> new PickaxeItem(AbyssTechToolTiers.VERDANT, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)AbyssTechToolTiers.VERDANT, (float)1.0f, (float)-1.9f))));
    public static final DeferredItem<Item> GRAVE_AXE = ITEMS.register("grave_axe", () -> new AxeItem(AbyssTechToolTiers.GRAVE, new Item.Properties().attributes(AxeItem.createAttributes((Tier)AbyssTechToolTiers.GRAVE, (float)8.0f, (float)-3.1f))));
    public static final DeferredItem<Item> VERDANT_SWORD = ITEMS.register("verdant_sword", () -> new SwordItem(AbyssTechToolTiers.VERDANT, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.VERDANT, (int)6, (float)-2.3f))));
    public static final DeferredItem<Item> GRAVE_SHOVEL = ITEMS.register("grave_shovel", () -> new ShovelItem(AbyssTechToolTiers.GRAVE, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)AbyssTechToolTiers.GRAVE, (float)1.0f, (float)-2.0f))));
    public static final DeferredItem<Item> VERDANT_HOE = ITEMS.register("verdant_hoe", () -> new HoeItem(AbyssTechToolTiers.VERDANT, new Item.Properties().attributes(HoeItem.createAttributes((Tier)AbyssTechToolTiers.VERDANT, (float)1.0f, (float)-1.0f))));
    public static final DeferredItem<Item> ABYSSAL_PICKAXE = ITEMS.register("abyssal_pickaxe", () -> new PickaxeItem(AbyssTechToolTiers.ABYSSAL, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)AbyssTechToolTiers.ABYSSAL, (float)1.0f, (float)-1.9f))));
    public static final DeferredItem<Item> ABYSSAL_AXE = ITEMS.register("abyssal_axe", () -> new AxeItem(AbyssTechToolTiers.ABYSSAL, new Item.Properties().attributes(AxeItem.createAttributes((Tier)AbyssTechToolTiers.ABYSSAL, (float)9.0f, (float)-3.1f))));
    public static final DeferredItem<Item> ABYSSAL_SWORD = ITEMS.register("abyssal_sword", () -> new SwordItem(AbyssTechToolTiers.ABYSSAL, new Item.Properties().attributes(SwordItem.createAttributes((Tier)AbyssTechToolTiers.ABYSSAL, (int)7, (float)-2.3f))));
    public static final DeferredItem<Item> ABYSSAL_SHOVEL = ITEMS.register("abyssal_shovel", () -> new ShovelItem(AbyssTechToolTiers.ABYSSAL, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)AbyssTechToolTiers.ABYSSAL, (float)1.0f, (float)-2.0f))));
    public static final DeferredItem<Item> ABYSSAL_HOE = ITEMS.register("abyssal_hoe", () -> new HoeItem(AbyssTechToolTiers.ABYSSAL, new Item.Properties().attributes(HoeItem.createAttributes((Tier)AbyssTechToolTiers.ABYSSAL, (float)1.0f, (float)-1.0f))));
    public static final DeferredItem<Item> BOUNDARY_HELMET = ITEMS.register("boundary_helmet", () -> new ArmorItem(AbyssTechArmorMaterials.BOUNDARY, ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(24))));
    public static final DeferredItem<Item> BOUNDARY_CHESTPLATE = ITEMS.register("boundary_chestplate", () -> new ArmorItem(AbyssTechArmorMaterials.BOUNDARY, ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(24))));
    public static final DeferredItem<Item> BOUNDARY_LEGGINGS = ITEMS.register("boundary_leggings", () -> new ArmorItem(AbyssTechArmorMaterials.BOUNDARY, ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(24))));
    public static final DeferredItem<Item> BOUNDARY_BOOTS = ITEMS.register("boundary_boots", () -> new ArmorItem(AbyssTechArmorMaterials.BOUNDARY, ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(24))));
    public static final DeferredItem<Item> UNBOUND_MANTRA = ITEMS.register("unbound_mantra", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> MARATHON_MANTRA = ITEMS.register("marathon_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> ANGRY_MANTRA = ITEMS.register("angry_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> PASSIONATE_MANTRA = ITEMS.register("passionate_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> SOFT_MANTRA = ITEMS.register("soft_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> STONE_MANTRA = ITEMS.register("stone_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> CAPTIVATING_MANTRA = ITEMS.register("captivating_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> WHIMSICAL_MANTRA = ITEMS.register("whimsical_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> STRANGE_MANTRA = ITEMS.register("strange_mantra", () -> new Mantra(new Item.Properties()));
    public static final DeferredItem<Item> LADYBUG_SPAWN_EGG = ITEMS.register("ladybug_spawn_egg", () -> new DeferredSpawnEggItem(AbysstechEntities.LADYBUG, 0xFF0000, 0, new Item.Properties()));
    public static final DeferredItem<Item> WANDERINGWISP_SPAWN_EGG = ITEMS.register("wanderingwisp_spawn_egg", () -> new DeferredSpawnEggItem(AbysstechEntities.WANDERINGWISP, 65531, 0xFFFFFF, new Item.Properties()));
    public static final DeferredItem<Item> HUGGINGSLUDGE_SPAWN_EGG = ITEMS.register("huggingsludge_spawn_egg", () -> new DeferredSpawnEggItem(AbysstechEntities.HUGGING_SLUDGE, 5849171, 13407669, new Item.Properties()));
    public static final DeferredItem<Item> SLUDGESPORE_SPAWN_EGG = ITEMS.register("sludgespore_spawn_egg", () -> new DeferredSpawnEggItem(AbysstechEntities.SLUDGE_SPORE, 5849171, 1314579, new Item.Properties()));
    public static final DeferredItem<Item> CHATTERER_SPAWN_EGG = ITEMS.register("chatterer_spawn_egg", () -> new DeferredSpawnEggItem(AbysstechEntities.CHATTERER, 5849171, 13407669, new Item.Properties()));
    public static final DeferredItem<Item> HOMUNCULI_SPAWN_EGG = ITEMS.register("homunculi_spawn_egg", () -> new DeferredSpawnEggItem(AbysstechEntities.HOMUNCULI, 5849171, 13407669, new Item.Properties()));
    public static final DeferredItem<Item> CREATIVE_TUNING_WAND = ITEMS.register("creative_tuning_wand", () -> new CreativeWand(new Item.Properties()));
    public static final DeferredItem<Item> TRIFECTA_ADVANC_ICON = ITEMS.register("trifecta_advanc_icon", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_ROOTING = ITEMS.register("icon_rooting", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_ROTTING = ITEMS.register("icon_rotting", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_STRANGE = ITEMS.register("icon_strange", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_CORPOREAL = ITEMS.register("icon_corporeal", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_IMAGINARY = ITEMS.register("icon_imaginary", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_RADIANT = ITEMS.register("icon_radiant", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_STYGIAN = ITEMS.register("icon_stygian", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> ICON_CHANGING = ITEMS.register("icon_changing", () -> new Item(new Item.Properties()));

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

