/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.entity.custom.EssenceJarBlockEntity;
import net.quasar.abysstech.block.entity.custom.PillarConductingBlockEntity;
import net.quasar.abysstech.block.entity.custom.XpMachineBlockEntity;
import net.quasar.abysstech.util.AbyssTechAttachmentType;

public class CreativeWand
extends Item {
    Random random = new Random();

    public CreativeWand(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        if (!level.isClientSide()) {
            BlockEntity blockEntity = level.getBlockEntity(clickedPos);
            if (blockEntity instanceof EssenceJarBlockEntity) {
                EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity;
                essenceJarBlock.setEssence(essenceJarBlock.getMaxEssence());
            }
            if ((blockEntity = level.getBlockEntity(clickedPos)) instanceof PillarConductingBlockEntity) {
                PillarConductingBlockEntity pillarConductingBlock = (PillarConductingBlockEntity)blockEntity;
                pillarConductingBlock.setEssence(pillarConductingBlock.getMaxEssence());
            }
            if ((blockEntity = level.getBlockEntity(clickedPos)) instanceof XpMachineBlockEntity) {
                XpMachineBlockEntity xpMachineBlockEntity = (XpMachineBlockEntity)blockEntity;
                xpMachineBlockEntity.setXpAmount(xpMachineBlockEntity.getMaxXpAmount());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if ((!player.isShiftKeyDown() || level.isClientSide()) && level.isClientSide()) {
            player.setData(AbyssTechAttachmentType.TOGGLE_ECHO_RENDER, (Object)((Boolean)player.getData(AbyssTechAttachmentType.TOGGLE_ECHO_RENDER) == false ? 1 : 0));
        }
        return InteractionResultHolder.success((Object)player.getMainHandItem());
    }

    private void flipTerrain(Level level, Player player) {
        BlockPos pos = player.getOnPos();
        int placeY = 319;
        for (int y = -63; y < 160; ++y) {
            for (int x = -8; x < 8; ++x) {
                for (int z = -8; z < 8; ++z) {
                    BlockPos t = new BlockPos(pos.getX() + x, y, pos.getZ() + z);
                    BlockState s = level.getBlockState(t);
                    if (s.isAir() || s.is(Blocks.BEDROCK)) continue;
                    level.removeBlock(t, false);
                    level.setBlockAndUpdate(new BlockPos(t.getX(), placeY, t.getZ()), s);
                }
            }
            --placeY;
        }
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (player instanceof ServerPlayer && interactionTarget instanceof Pig) {
            String[][] nameList = new String[][]{{"Radiant ", "Stygian ", "Dreaming ", "Erratic ", "Devouring ", "Ever Burning "}, {"Giant of the ", "Watcher of the ", "Knight of the ", "Lord of the ", "Pillar of the ", "Hopper of the "}, {"Ever Growing ", "Festering ", "Withered ", "Ruined ", "Beautiful ", "sleeping "}, {"Sands", "Slip", "Wastelands", "Tower", "Doorway", "Road"}};
            Object nameOfMob = "";
            for (int i = 0; i < nameList.length; ++i) {
                nameOfMob = (String)nameOfMob + nameList[i][this.random.nextInt(nameList[i].length)];
            }
            if (this.random.nextInt(10000) == 1) {
                nameOfMob = "This is a very Long name for this mob that you just right clicked with a creative tuning wand, and you are lucky for encountering this because it is a 1 in 10000 chance of happening. I placed this here to see how long of a name I could give a mob and to see what effects if any would happen if done so.";
            }
            int color = this.random.nextInt(231) + 25 << 16 | this.random.nextInt(231) + 25 << 8 | this.random.nextInt(231) + 25;
            interactionTarget.setCustomName((Component)Component.literal((String)nameOfMob).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)color))));
            interactionTarget.setCustomNameVisible(true);
        }
        return InteractionResult.SUCCESS;
    }
}

