/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.quasar.abysstech.block.AbyssTechBlocks;

public class CrystalPrepKit
extends Item {
    private static final Map<Block, Block> PREP_MAP = Map.of(Blocks.DRIPSTONE_BLOCK, (Block)AbyssTechBlocks.DRIP_STONE_PREP.get());

    public CrystalPrepKit(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Block clickedBlock = level.getBlockState(context.getClickedPos()).getBlock();
        BlockPos clickedPos = context.getClickedPos();
        if (!level.isClientSide() && PREP_MAP.containsKey(clickedBlock)) {
            ((ServerLevel)level).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, clickedBlock.defaultBlockState()), (double)((float)clickedPos.getX() + 0.5f), (double)((float)clickedPos.getY() + 1.5f), (double)((float)clickedPos.getZ() + 0.5f), 10, 0.5, 0.5, 0.5, 0.0);
            level.setBlockAndUpdate(context.getClickedPos(), PREP_MAP.get(clickedBlock).defaultBlockState());
            context.getItemInHand().hurtAndBreak(1, (ServerLevel)level, (LivingEntity)context.getPlayer(), item -> context.getPlayer().onEquippedItemBroken(item, EquipmentSlot.MAINHAND));
            level.playSound(null, context.getClickedPos(), SoundEvents.BASALT_BREAK, SoundSource.BLOCKS);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.crystal_prep_kit.tooltip.1"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.crystal_prep_kit.tooltip.2"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.ofNullable((BundleContents)stack.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new);
    }
}

