/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.quasar.abysstech.component.AbyssTechDataComponentTypes;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class InstabilityDetector
extends Item {
    private final int highUnstable = 10000;
    private final int medUnstable = 5000;
    private final int lowUnstable = 1000;
    private int detectedInstability = 0;
    private int tick = 0;
    private final int tickRate = 3;
    private int updateTick = 0;
    private final int updateTickRate = 3;

    public InstabilityDetector(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide()) {
            int n = this.tick = this.tick > 3 ? 0 : this.tick + 1;
            if (this.tick > 3) {
                int n2 = this.updateTick = this.updateTick > 3 ? 1 : this.updateTick + 1;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (isSelected) {
                        BlockPos pos = player.blockPosition();
                        if (this.updateTick > 3) {
                            int currentChunkInstability = AbyssTechUtility.getThresholdIntegrity(level, pos);
                            this.detectedInstability = currentChunkInstability >= 10000 ? 3 : (currentChunkInstability >= 5000 ? 2 : (currentChunkInstability >= 1000 ? 1 : 0));
                            stack.set((DataComponentType)AbyssTechDataComponentTypes.UNSTABLE_AMOUNT.get(), (Object)this.detectedInstability);
                        }
                        switch (this.detectedInstability) {
                            case 1: {
                                if (this.updateTick != 1) break;
                                level.playSound(null, pos, AbyssTechSounds.UNSTABLE_DETECT.get(), SoundSource.BLOCKS, 1.0f, 0.5f);
                                break;
                            }
                            case 2: {
                                if (this.updateTick != 1 && this.updateTick != 3) break;
                                level.playSound(null, pos, AbyssTechSounds.UNSTABLE_DETECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                break;
                            }
                            case 3: {
                                level.playSound(null, pos, AbyssTechSounds.UNSTABLE_DETECT.get(), SoundSource.BLOCKS, 1.0f, 1.5f);
                            }
                        }
                    }
                }
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (!level.isClientSide()) {
            String instabilityToString;
            int instability = AbyssTechUtility.getThresholdIntegrity(level, pos);
            Object object = instability < 1 ? "No instability detected" : (instability < 1000 ? "Light Instability, value: " + instability : (instability < 5000 ? "Moderate Insta\u00a7kbi\u00a7rlity, value: " + instability : (instabilityToString = instability < 10000 ? "He\u00a7ka\u00a7rvy In\u00a7kst\u00a7rabil\u00a7ki\u00a7rty, \u00a7kv\u00a7ralue: " + instability : "Danger\u00a7kous\u00a7r Instabi\u00a7klity, I recommend to\u00a7r leave \u00a7kimmediatel\u00a7ry, v\u00a7kalue\u00a7r: " + instability)));
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)instabilityToString), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }
}

