/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.entity.custom.EssenceJarBlockEntity;
import net.quasar.abysstech.component.AbyssTechDataComponentTypes;

public class JarRelocator
extends Item {
    public JarRelocator(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Block clickedBlock = level.getBlockState(context.getClickedPos()).getBlock();
        Block checkAbove = level.getBlockState(context.getClickedPos().above(1)).getBlock();
        if (!level.isClientSide()) {
            if (clickedBlock == AbyssTechBlocks.ESSENCE_JAR.get() && context.getItemInHand().get(AbyssTechDataComponentTypes.STORED_ESSENCE) == null) {
                BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
                if (blockEntity instanceof EssenceJarBlockEntity) {
                    EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity;
                    context.getItemInHand().set((DataComponentType)AbyssTechDataComponentTypes.STORED_ESSENCE.get(), (Object)essenceJarBlock.getEssence());
                    level.removeBlock(context.getClickedPos(), false);
                    level.playSound(null, context.getClickedPos(), SoundEvents.DECORATED_POT_PLACE, SoundSource.BLOCKS);
                }
            } else if ((checkAbove == Blocks.AIR || checkAbove == Blocks.CAVE_AIR || clickedBlock == Blocks.AIR || clickedBlock == Blocks.CAVE_AIR) && context.getItemInHand().get(AbyssTechDataComponentTypes.STORED_ESSENCE) != null) {
                if (clickedBlock == Blocks.AIR || clickedBlock == Blocks.CAVE_AIR) {
                    level.setBlockAndUpdate(context.getClickedPos(), ((Block)AbyssTechBlocks.ESSENCE_JAR.get()).defaultBlockState());
                    BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
                    if (blockEntity instanceof EssenceJarBlockEntity) {
                        EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity;
                        essenceJarBlock.setEssence((Integer)context.getItemInHand().get(AbyssTechDataComponentTypes.STORED_ESSENCE));
                    }
                } else {
                    level.setBlockAndUpdate(context.getClickedPos().above(1), ((Block)AbyssTechBlocks.ESSENCE_JAR.get()).defaultBlockState());
                    BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos().above(1));
                    if (blockEntity instanceof EssenceJarBlockEntity) {
                        EssenceJarBlockEntity essenceJarBlock = (EssenceJarBlockEntity)blockEntity;
                        essenceJarBlock.setEssence((Integer)context.getItemInHand().get(AbyssTechDataComponentTypes.STORED_ESSENCE));
                    }
                }
                context.getItemInHand().set((DataComponentType)AbyssTechDataComponentTypes.STORED_ESSENCE.get(), null);
                level.playSound(null, context.getClickedPos(), SoundEvents.DECORATED_POT_PLACE, SoundSource.BLOCKS);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

