/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.MultiBlockSegment;
import net.quasar.abysstech.block.custom.ThresholdObelisk;
import net.quasar.abysstech.component.AbyssTechDataComponentTypes;
import net.quasar.abysstech.effect.AbyssTechEffects;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechShapePlacerUtil;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;

public class Mantra
extends Item {
    Random random = new Random();

    public Mantra(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!level.isClientSide()) {
            Item[] mantraType = new Item[]{(Item)AbyssTechItems.MARATHON_MANTRA.get(), (Item)AbyssTechItems.ANGRY_MANTRA.get(), (Item)AbyssTechItems.PASSIONATE_MANTRA.get(), (Item)AbyssTechItems.SOFT_MANTRA.get(), (Item)AbyssTechItems.STONE_MANTRA.get(), (Item)AbyssTechItems.CAPTIVATING_MANTRA.get(), (Item)AbyssTechItems.WHIMSICAL_MANTRA.get(), (Item)AbyssTechItems.STRANGE_MANTRA.get()};
            ItemStack heldMantra = player.getMainHandItem();
            for (int i = 0; i < mantraType.length; ++i) {
                if (!heldMantra.is(mantraType[i])) continue;
                int stainType = 0;
                int stainScent = 0;
                int stainSaturation = 0;
                if (heldMantra.get(AbyssTechDataComponentTypes.STAIN_TYPE) != null) {
                    stainType = (Integer)heldMantra.get(AbyssTechDataComponentTypes.STAIN_TYPE);
                    stainScent = (Integer)heldMantra.get(AbyssTechDataComponentTypes.STAIN_SCENT);
                    stainSaturation = (Integer)heldMantra.get(AbyssTechDataComponentTypes.STAIN_SATURATION);
                }
                if (stainType > 0 && stainScent > 0) {
                    switch (i) {
                        case 0: {
                            this.marathonUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                        case 1: {
                            this.angryUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                        case 2: {
                            this.passionateUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                        case 3: {
                            this.softUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                        case 4: {
                            this.stoneUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                        case 5: {
                            this.captivatingUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                        case 6: {
                            this.whimsicalUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                        case 7: {
                            this.strangeUse(level, player, stainType, stainScent, stainSaturation);
                            break;
                        }
                    }
                } else {
                    this.useNoModifiers(level, player, i);
                }
                level.playSound(null, player.getOnPos(), AbyssTechSounds.MANTRA_USE.get(), SoundSource.BLOCKS, 1.0f, this.random.nextFloat(2.0f));
                player.getMainHandItem().shrink(1);
                break;
            }
        }
        return InteractionResultHolder.success((Object)player.getMainHandItem());
    }

    private void marathonUse(Level level, Player player, int type, int targetType, int amplify) {
        Holder<MobEffect> effectHolder;
        boolean isInstant = false;
        switch (type) {
            case 1: {
                effectHolder = MobEffects.MOVEMENT_SLOWDOWN;
                amplify /= 3;
                break;
            }
            case 2: {
                effectHolder = AbyssTechEffects.EARLY_BIRD_EFFECT;
                break;
            }
            case 3: {
                effectHolder = AbyssTechEffects.SPRINTER_EFFECT;
                break;
            }
            case 4: {
                effectHolder = MobEffects.MOVEMENT_SPEED;
                amplify /= 3;
                break;
            }
            case 5: {
                effectHolder = AbyssTechEffects.PANIC_EFFECT;
                break;
            }
            case 6: {
                effectHolder = AbyssTechEffects.WITH_THE_WIND_EFFECT;
                break;
            }
            case 7: {
                effectHolder = AbyssTechEffects.STEAD_EFFECT;
                break;
            }
            case 8: {
                effectHolder = AbyssTechEffects.DIVER_EFFECT;
                break;
            }
            default: {
                effectHolder = null;
            }
        }
        if (effectHolder != null) {
            switch (targetType) {
                case 1: 
                case 2: {
                    this.useOneSelf(player, effectHolder, amplify, isInstant);
                    break;
                }
                case 3: 
                case 4: {
                    this.useAllRange(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 5: 
                case 6: {
                    this.useOnTarget(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 7: 
                case 8: {
                    this.useRangeNotSelf(level, player, effectHolder, amplify, isInstant);
                }
            }
        } else {
            this.unimplementedStain(player);
        }
    }

    private void angryUse(Level level, Player player, int type, int targetType, int amplify) {
        Holder effectHolder;
        boolean isInstant = false;
        switch (type) {
            case 1: {
                effectHolder = AbyssTechEffects.RAGE_EFFECT;
                break;
            }
            case 2: {
                effectHolder = AbyssTechEffects.DESPERATION_EFFECT;
                break;
            }
            case 3: {
                effectHolder = AbyssTechEffects.SPITE_EFFECT;
                break;
            }
            case 4: {
                effectHolder = MobEffects.HARM;
                isInstant = true;
                amplify /= 3;
                break;
            }
            case 5: {
                effectHolder = AbyssTechEffects.DWELLER_EFFECT;
                break;
            }
            case 6: {
                effectHolder = AbyssTechEffects.INFERNAL_EFFECT;
                break;
            }
            case 7: {
                effectHolder = AbyssTechEffects.BATTER_EFFECT;
                break;
            }
            case 8: {
                effectHolder = MobEffects.DAMAGE_BOOST;
                amplify /= 3;
                break;
            }
            default: {
                effectHolder = null;
            }
        }
        if (effectHolder != null) {
            switch (targetType) {
                case 1: 
                case 2: {
                    this.useOneSelf(player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                    break;
                }
                case 3: 
                case 4: {
                    this.useAllRange(level, player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                    break;
                }
                case 5: 
                case 6: {
                    this.useOnTarget(level, player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                    break;
                }
                case 7: 
                case 8: {
                    this.useRangeNotSelf(level, player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                }
            }
        } else {
            this.unimplementedStain(player);
        }
    }

    private void passionateUse(Level level, Player player, int type, int targetType, int amplify) {
        Holder effectHolder;
        boolean isInstant = false;
        switch (type) {
            case 1: {
                effectHolder = MobEffects.WEAKNESS;
                amplify /= 3;
                break;
            }
            case 2: {
                effectHolder = AbyssTechEffects.SECOND_WIND_EFFECT;
                break;
            }
            case 3: {
                effectHolder = MobEffects.HEAL;
                isInstant = true;
                amplify /= 3;
                break;
            }
            case 4: {
                effectHolder = AbyssTechEffects.PHOTOSYNTHESIS_EFFECT;
                break;
            }
            case 5: {
                effectHolder = AbyssTechEffects.STONE_BLOOD_EFFECT;
                break;
            }
            case 6: {
                effectHolder = AbyssTechEffects.SKY_BLOOD_EFFECT;
                break;
            }
            case 7: {
                effectHolder = AbyssTechEffects.FIRE_BLOOD_EFFECT;
                break;
            }
            case 8: {
                effectHolder = MobEffects.REGENERATION;
                amplify /= 3;
                break;
            }
            default: {
                effectHolder = null;
            }
        }
        if (effectHolder != null) {
            switch (targetType) {
                case 1: 
                case 2: {
                    this.useOneSelf(player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                    break;
                }
                case 3: 
                case 4: {
                    this.useAllRange(level, player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                    break;
                }
                case 5: 
                case 6: {
                    this.useOnTarget(level, player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                    break;
                }
                case 7: 
                case 8: {
                    this.useRangeNotSelf(level, player, (Holder<MobEffect>)effectHolder, amplify, isInstant);
                }
            }
        } else {
            this.unimplementedStain(player);
        }
    }

    private void softUse(Level level, Player player, int type, int targetType, int amplify) {
        Holder<MobEffect> effectHolder;
        boolean isInstant = false;
        switch (type) {
            case 1: {
                effectHolder = AbyssTechEffects.BREACH_BANE_EFFECT;
                break;
            }
            case 2: {
                effectHolder = MobEffects.ABSORPTION;
                amplify /= 3;
                break;
            }
            case 3: {
                effectHolder = MobEffects.DAMAGE_RESISTANCE;
                amplify /= 3;
                break;
            }
            case 4: {
                effectHolder = AbyssTechEffects.GRASS_FLESH_EFFECT;
                break;
            }
            case 5: {
                effectHolder = AbyssTechEffects.SHADOW_FLESH_EFFECT;
                break;
            }
            case 6: {
                effectHolder = AbyssTechEffects.SUN_FLESH_EFFECT;
                break;
            }
            case 7: {
                effectHolder = AbyssTechEffects.IRON_STOMACH_EFFECT;
                break;
            }
            case 8: {
                effectHolder = AbyssTechEffects.TITANIUM_LEGS_EFFECT;
                break;
            }
            default: {
                effectHolder = null;
            }
        }
        if (effectHolder != null) {
            switch (targetType) {
                case 1: 
                case 2: {
                    this.useOneSelf(player, effectHolder, amplify, isInstant);
                    break;
                }
                case 3: 
                case 4: {
                    this.useAllRange(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 5: 
                case 6: {
                    this.useOnTarget(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 7: 
                case 8: {
                    this.useRangeNotSelf(level, player, effectHolder, amplify, isInstant);
                }
            }
        } else {
            this.unimplementedStain(player);
        }
    }

    private void stoneUse(Level level, Player player, int type, int range, int amplify) {
        BlockPos pos = player.getOnPos();
        switch (type) {
            case 1: {
                this.replaceStoneWithDirt(level, pos, range, amplify);
                break;
            }
            case 2: {
                this.replaceDirtWithStone(level, pos, range, amplify);
                break;
            }
            case 3: {
                this.trapEntitiesInStone(level, player, range, amplify);
                break;
            }
            case 4: {
                this.replaceStoneWithCopper(level, pos, range, amplify);
                break;
            }
            case 5: {
                this.spawnAcid(level, pos, range, amplify);
                break;
            }
            case 6: {
                this.growRandomCrops(level, pos, range, amplify);
                break;
            }
            case 7: {
                this.replaceStoneWithDecentOre(level, pos, range, amplify);
                break;
            }
            case 8: {
                this.replaceStoneWithValuableOre(level, pos, range, amplify);
                break;
            }
            default: {
                this.unimplementedStain(player);
            }
        }
    }

    private void captivatingUse(Level level, Player player, int type, int targetType, int amplify) {
        Holder<MobEffect> effectHolder;
        boolean isInstant = false;
        switch (type) {
            case 1: {
                Holder<MobEffect> holder = AbyssTechEffects.REPULSIVE_EFFECT;
                break;
            }
            case 2: {
                Holder<MobEffect> holder = AbyssTechEffects.HATEFUL_EYE_EFFECT;
                break;
            }
            case 3: {
                Holder<MobEffect> holder = AbyssTechEffects.GREEDY_GRASP_EFFECT;
                break;
            }
            case 4: {
                Holder<MobEffect> holder = AbyssTechEffects.CAPTIVATING_EFFECT;
                break;
            }
            case 5: {
                Holder<MobEffect> holder = AbyssTechEffects.NULL_PULL_EFFECT;
                break;
            }
            case 6: {
                Holder<MobEffect> holder = AbyssTechEffects.SKIES_EYE_EFFECT;
                break;
            }
            case 7: {
                Holder<MobEffect> holder = AbyssTechEffects.GRASPING_EYE_EFFECT;
                break;
            }
            case 8: {
                Holder<MobEffect> holder = AbyssTechEffects.ELECTRIFYING_EFFECT;
                break;
            }
            default: {
                Holder<MobEffect> holder = effectHolder = null;
            }
        }
        if (effectHolder != null) {
            switch (targetType) {
                case 1: 
                case 2: {
                    this.useOneSelf(player, effectHolder, amplify, isInstant);
                    break;
                }
                case 3: 
                case 4: {
                    this.useAllRange(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 5: 
                case 6: {
                    this.useOnTarget(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 7: 
                case 8: {
                    this.useRangeNotSelf(level, player, effectHolder, amplify, isInstant);
                }
            }
        } else {
            this.unimplementedStain(player);
        }
    }

    private void whimsicalUse(Level level, Player player, int type, int targetType, int amplify) {
        Holder<MobEffect> effectHolder;
        boolean isInstant = false;
        switch (type) {
            case 1: {
                Holder<MobEffect> holder = AbyssTechEffects.GREASED_EFFECT;
                break;
            }
            case 2: {
                Holder<MobEffect> holder = null;
                break;
            }
            case 3: {
                Holder<MobEffect> holder = null;
                break;
            }
            case 4: {
                Holder<MobEffect> holder = AbyssTechEffects.WHIMSICAL_EFFECT;
                break;
            }
            case 5: {
                Holder<MobEffect> holder = AbyssTechEffects.TINY_EFFECT;
                break;
            }
            case 6: {
                Holder<MobEffect> holder = AbyssTechEffects.GIANT_EFFECT;
                break;
            }
            case 7: {
                Holder<MobEffect> holder = null;
                break;
            }
            case 8: {
                Holder<MobEffect> holder = AbyssTechEffects.EXPLOSIVE_EXIT_EFFECT;
                break;
            }
            default: {
                Holder<MobEffect> holder = effectHolder = null;
            }
        }
        if (effectHolder != null) {
            switch (targetType) {
                case 1: 
                case 2: {
                    this.useOneSelf(player, effectHolder, amplify, isInstant);
                    break;
                }
                case 3: 
                case 4: {
                    this.useAllRange(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 5: 
                case 6: {
                    this.useOnTarget(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 7: 
                case 8: {
                    this.useRangeNotSelf(level, player, effectHolder, amplify, isInstant);
                }
            }
        } else {
            this.unimplementedStain(player);
        }
    }

    private void strangeUse(Level level, Player player, int type, int range, int amplify) {
        BlockPos pos = player.getOnPos();
        boolean isInstant = false;
        Holder<MobEffect> effectHolder = null;
        switch (type) {
            case 1: {
                this.setSodBlock(level, pos, player, this.random.nextInt(2), range, amplify);
                break;
            }
            case 2: {
                effectHolder = AbyssTechEffects.TELEKINESIS_EFFECT;
                break;
            }
            case 3: {
                this.setObelisk(level, pos, range, amplify);
                break;
            }
            case 4: {
                this.setSodBlock(level, pos, player, 0, range, amplify);
                break;
            }
            case 5: {
                this.setSodBlock(level, pos, player, 1, range, amplify);
                break;
            }
            case 6: {
                this.setSodBlock(level, pos, player, 2, range, amplify);
                break;
            }
            case 7: {
                this.unimplementedStain(player);
                break;
            }
            case 8: {
                effectHolder = AbyssTechEffects.GUILE_EFFECT;
                break;
            }
            default: {
                this.unimplementedStain(player);
            }
        }
        if (effectHolder != null) {
            switch (range) {
                case 1: 
                case 2: {
                    this.useOneSelf(player, effectHolder, amplify, isInstant);
                    break;
                }
                case 3: 
                case 4: {
                    this.useAllRange(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 5: 
                case 6: {
                    this.useOnTarget(level, player, effectHolder, amplify, isInstant);
                    break;
                }
                case 7: 
                case 8: {
                    this.useRangeNotSelf(level, player, effectHolder, amplify, isInstant);
                }
            }
        }
    }

    private void useOneSelf(Player player, Holder<MobEffect> effect, int amplify, boolean instant) {
        int duration = 800;
        if (instant) {
            duration = 1;
        }
        player.addEffect(new MobEffectInstance(effect, duration, amplify));
    }

    private void useAllRange(Level level, Player player, Holder<MobEffect> effect, int amplify, boolean instant) {
        BlockPos pos = player.blockPosition();
        double mobSearchRadius = 6.0;
        int duration = 800;
        if (instant) {
            duration = 1;
        }
        List entityToEffect = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)pos.getX() - mobSearchRadius, (double)pos.getY() - mobSearchRadius, (double)pos.getZ() - mobSearchRadius, (double)pos.getX() + mobSearchRadius, (double)pos.getY() + mobSearchRadius, (double)pos.getZ() + mobSearchRadius));
        for (LivingEntity livingEntity : entityToEffect) {
            livingEntity.addEffect(new MobEffectInstance(effect, duration, amplify));
        }
    }

    private void useRangeNotSelf(Level level, Player player, Holder<MobEffect> effect, int amplify, boolean instant) {
        BlockPos pos = player.blockPosition();
        double mobSearchRadius = 6.0;
        int duration = 800;
        if (instant) {
            duration = 1;
        }
        List entityToEffect = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)pos.getX() - mobSearchRadius, (double)pos.getY() - mobSearchRadius, (double)pos.getZ() - mobSearchRadius, (double)pos.getX() + mobSearchRadius, (double)pos.getY() + mobSearchRadius, (double)pos.getZ() + mobSearchRadius));
        for (LivingEntity livingEntity : entityToEffect) {
            if (livingEntity == player) continue;
            livingEntity.addEffect(new MobEffectInstance(effect, duration, amplify));
        }
    }

    private void useOnTarget(Level level, Player player, Holder<MobEffect> effect, int amplify, boolean instant) {
        BlockPos pos = player.blockPosition();
        double smallRadius = 3.0;
        int duration = 800;
        if (instant) {
            duration = 1;
        }
        BlockPos targetPos = AbyssTechUtility.getLookBlockPosCollider(level, (LivingEntity)player, 0.5f, 5 + amplify);
        List targetEntities = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)targetPos.getX() - smallRadius, (double)targetPos.getY() - smallRadius, (double)targetPos.getZ() - smallRadius, (double)targetPos.getX() + smallRadius, (double)targetPos.getY() + smallRadius, (double)targetPos.getZ() + smallRadius));
        for (LivingEntity livingEntity : targetEntities) {
            livingEntity.addEffect(new MobEffectInstance(effect, duration, amplify));
        }
    }

    private void useNoModifiers(Level level, Player player, int mantra) {
        BlockPos pos = player.blockPosition();
        double mobSearchRadius = 6.0;
        List entityToEffect = level.getEntitiesOfClass(LivingEntity.class, new AABB((double)pos.getX() - mobSearchRadius, (double)pos.getY() - mobSearchRadius, (double)pos.getZ() - mobSearchRadius, (double)pos.getX() + mobSearchRadius, (double)pos.getY() + mobSearchRadius, (double)pos.getZ() + mobSearchRadius));
        switch (mantra) {
            case 0: {
                for (LivingEntity livingEntity : entityToEffect) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 800, 1));
                }
                break;
            }
            case 1: {
                for (LivingEntity livingEntity : entityToEffect) {
                    if (livingEntity == player) continue;
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
                }
                break;
            }
            case 2: {
                for (LivingEntity livingEntity : entityToEffect) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.HEAL, 1, 1));
                }
                break;
            }
            case 3: {
                for (LivingEntity livingEntity : entityToEffect) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 400, 0));
                }
                break;
            }
            case 4: {
                this.replaceStoneWithCopper(level, pos.below(1), 5, 0);
                break;
            }
            case 5: {
                player.addEffect(new MobEffectInstance(AbyssTechEffects.CAPTIVATING_EFFECT, 400, 0));
                break;
            }
            case 6: {
                player.addEffect(new MobEffectInstance(AbyssTechEffects.WHIMSICAL_EFFECT, 400, 0));
                break;
            }
            case 7: {
                this.setSodBlock(level, pos, player, this.random.nextInt(2), 4, 0);
            }
        }
    }

    private void setObelisk(Level level, BlockPos pos, int range, int amplify) {
        range += 4;
        amplify = Math.min(10, amplify + 5);
        for (int i = 0; i < 10; ++i) {
            BlockPos tPos = this.randomPosFromCenter(pos, range, false, true, false);
            if (level.getBlockState(tPos).isAir() && level.getBlockState(tPos.above(1)).isAir() && level.getBlockState(tPos.above(2)).isAir()) {
                level.setBlockAndUpdate(tPos, (BlockState)((BlockState)((BlockState)((Block)AbyssTechBlocks.THRESHOLD_OBELISK.get()).defaultBlockState().setValue((Property)ThresholdObelisk.SEGMENT, (Comparable)((Object)MultiBlockSegment.BOTTOM))).setValue((Property)ThresholdObelisk.CHARGE, (Comparable)Integer.valueOf(amplify))).setValue((Property)ThresholdObelisk.SWAY, (Comparable)Integer.valueOf(this.random.nextInt(2))));
                ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.GREEN_FLAME.get(), (double)((float)tPos.getX() + 0.5f), (double)((float)tPos.getY() + 0.9f), (double)((float)tPos.getZ() + 0.5f), 12, (double)0.8f, (double)0.8f, (double)0.8f, (double)0.05f);
                ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.RED_FLAME.get(), (double)((float)tPos.getX() + 0.5f), (double)((float)tPos.getY() + 0.9f), (double)((float)tPos.getZ() + 0.5f), 12, (double)0.8f, (double)0.8f, (double)0.8f, (double)0.05f);
                return;
            }
            if (!level.getBlockState(pos.above(3)).isAir() || !level.getBlockState(pos.above(4)).isAir() || !level.getBlockState(pos.above(5)).isAir()) continue;
            level.setBlockAndUpdate(pos.above(3), (BlockState)((BlockState)((BlockState)((Block)AbyssTechBlocks.THRESHOLD_OBELISK.get()).defaultBlockState().setValue((Property)ThresholdObelisk.SEGMENT, (Comparable)((Object)MultiBlockSegment.BOTTOM))).setValue((Property)ThresholdObelisk.CHARGE, (Comparable)Integer.valueOf(amplify))).setValue((Property)ThresholdObelisk.SWAY, (Comparable)Integer.valueOf(this.random.nextInt(2))));
            ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.GREEN_FLAME.get(), (double)((float)pos.above(3).getX() + 0.5f), (double)((float)pos.above(3).getY() + 0.9f), (double)((float)pos.above(3).getZ() + 0.5f), 12, (double)0.8f, (double)0.8f, (double)0.8f, (double)0.05f);
            ((ServerLevel)level).sendParticles((ParticleOptions)AbyssTechParticles.RED_FLAME.get(), (double)((float)pos.above(3).getX() + 0.5f), (double)((float)pos.above(3).getY() + 0.9f), (double)((float)pos.above(3).getZ() + 0.5f), 12, (double)0.8f, (double)0.8f, (double)0.8f, (double)0.05f);
        }
    }

    private void setSodBlock(Level level, BlockPos pos, Player player, int type, int range, int amplify) {
        BlockPos tPos = range < 4 ? pos : AbyssTechUtility.getLookBlockPosCollider(level, (LivingEntity)player, 0.5f, 5 + amplify);
        Block[] sodLike = new Block[]{(Block)AbyssTechBlocks.DREADFUL_SOD.get(), (Block)AbyssTechBlocks.STRANGE_SOD.get(), (Block)AbyssTechBlocks.WONDERFUL_SOD.get()};
        SimpleParticleType[] particles = new SimpleParticleType[]{AbyssTechParticles.RED_FLAME.get(), AbyssTechParticles.STRANGE_FLAME.get(), AbyssTechParticles.GREEN_FLAME.get()};
        ((ServerLevel)level).sendParticles((ParticleOptions)particles[type], (double)((float)tPos.getX() + 0.5f), (double)((float)tPos.getY() + 0.9f), (double)((float)tPos.getZ() + 0.5f), 8 + amplify, 2.0, 2.0, 2.0, (double)0.05f);
        AbyssTechShapePlacerUtil.placeFilledSphere(level, tPos, sodLike[type], AbyssTechTags.Blocks.GRASS_LIKE, 1 + amplify / 3, false);
    }

    private void replaceStoneWithDirt(Level level, BlockPos pos, int range, int amplify) {
        if (level.getBlockState(pos).is(BlockTags.STONE_ORE_REPLACEABLES)) {
            level.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
        }
        for (int i = 0; i < 12 + amplify * 3; ++i) {
            BlockPos tPos = this.randomPosFromCenter(pos, range, false, true, false);
            if (!level.getBlockState(tPos).is(BlockTags.STONE_ORE_REPLACEABLES)) continue;
            level.setBlockAndUpdate(tPos, Blocks.DIRT.defaultBlockState());
        }
    }

    private void replaceDirtWithStone(Level level, BlockPos pos, int range, int amplify) {
        if (level.getBlockState(pos).is(BlockTags.DIRT)) {
            level.setBlockAndUpdate(pos, Blocks.STONE.defaultBlockState());
        }
        for (int i = 0; i < 12 + amplify * 3; ++i) {
            BlockPos tPos = this.randomPosFromCenter(pos, range, false, true, false);
            if (!level.getBlockState(tPos).is(BlockTags.DIRT)) continue;
            level.setBlockAndUpdate(tPos, Blocks.STONE.defaultBlockState());
        }
    }

    private void replaceStoneWithCopper(Level level, BlockPos pos, int range, int amplify) {
        if (level.getBlockState(pos).is(BlockTags.STONE_ORE_REPLACEABLES)) {
            level.setBlockAndUpdate(pos, Blocks.COPPER_ORE.defaultBlockState());
        }
        for (int i = 0; i < 6 + amplify * 2; ++i) {
            BlockPos tPos = this.randomPosFromCenter(pos, range, false, false, false);
            if (!level.getBlockState(tPos).is(BlockTags.STONE_ORE_REPLACEABLES)) continue;
            level.setBlockAndUpdate(tPos, Blocks.COPPER_ORE.defaultBlockState());
        }
    }

    private void replaceStoneWithDecentOre(Level level, BlockPos pos, int range, int amplify) {
        BlockState[] oreLike = new BlockState[]{Blocks.IRON_ORE.defaultBlockState(), Blocks.COPPER_ORE.defaultBlockState(), Blocks.LAPIS_ORE.defaultBlockState()};
        if (level.getBlockState(pos).is(BlockTags.STONE_ORE_REPLACEABLES)) {
            level.setBlockAndUpdate(pos, oreLike[this.random.nextInt(oreLike.length)]);
        }
        for (int i = 0; i < 6 + amplify * 2; ++i) {
            BlockPos tPos = this.randomPosFromCenter(pos, range, false, false, false);
            if (!level.getBlockState(tPos).is(BlockTags.STONE_ORE_REPLACEABLES)) continue;
            level.setBlockAndUpdate(tPos, oreLike[this.random.nextInt(oreLike.length)]);
        }
    }

    private void replaceStoneWithValuableOre(Level level, BlockPos pos, int range, int amplify) {
        BlockState[] oreLike = new BlockState[]{Blocks.GOLD_ORE.defaultBlockState(), Blocks.REDSTONE_ORE.defaultBlockState(), Blocks.EMERALD_ORE.defaultBlockState()};
        if (level.getBlockState(pos).is(BlockTags.STONE_ORE_REPLACEABLES)) {
            level.setBlockAndUpdate(pos, oreLike[this.random.nextInt(oreLike.length)]);
        }
        for (int i = 0; i < 6 + amplify * 2; ++i) {
            BlockPos tPos = this.randomPosFromCenter(pos, range, false, false, false);
            if (!level.getBlockState(tPos).is(BlockTags.STONE_ORE_REPLACEABLES)) continue;
            level.setBlockAndUpdate(tPos, oreLike[this.random.nextInt(oreLike.length)]);
        }
    }

    private void growRandomCrops(Level level, BlockPos pos, int range, int amplify) {
        for (int i = 0; i < 5 + amplify * 2; ++i) {
            BlockPos randPos = pos.offset(this.random.nextInt(range) - range / 2, this.random.nextInt(range) - range / 2, this.random.nextInt(range) - range / 2);
            if (!BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)level, (BlockPos)randPos, null) && !BoneMealItem.growWaterPlant((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)level, (BlockPos)randPos, null)) continue;
            level.levelEvent(2005, randPos, 0);
        }
    }

    private void trapEntitiesInStone(Level level, Player player, int range, int amplify) {
        BlockPos pos = player.blockPosition();
        List monsterToEffect = level.getEntitiesOfClass(Monster.class, new AABB((double)pos.getX() - (double)range, (double)pos.getY() - (double)range, (double)pos.getZ() - (double)range, (double)pos.getX() + (double)range, (double)pos.getY() + (double)range, (double)pos.getZ() + (double)range));
        BlockState[] toReplace = new BlockState[]{Blocks.DIRT.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.TUFF.defaultBlockState(), Blocks.DRIPSTONE_BLOCK.defaultBlockState(), Blocks.DEEPSLATE.defaultBlockState(), Blocks.BLACKSTONE.defaultBlockState(), ((Block)AbyssTechBlocks.MORT_MARBLE.get()).defaultBlockState(), ((Block)AbyssTechBlocks.MORT_STONE.get()).defaultBlockState()};
        for (Monster monster : monsterToEffect) {
            BlockPos footBlock = monster.blockPosition();
            BlockPos headBlock = monster.blockPosition().above(1);
            monster.discard();
            BlockState blockSet = toReplace[Math.min(toReplace.length, amplify)];
            level.setBlockAndUpdate(footBlock, blockSet);
            level.setBlockAndUpdate(headBlock, blockSet);
        }
    }

    private void spawnAcid(Level level, BlockPos pos, int range, int amplify) {
        for (int i = 0; i < 3 + amplify; ++i) {
            BlockPos tPos = this.randomPosFromCenter(pos, range, false, false, false);
            if (!level.getBlockState(tPos).is(BlockTags.STONE_ORE_REPLACEABLES) && !level.getBlockState(tPos).is(BlockTags.DIRT)) continue;
            level.setBlockAndUpdate(tPos, ((Block)AbyssTechBlocks.ACID_BLOCK.get()).defaultBlockState());
        }
    }

    private BlockPos randomPosFromCenter(BlockPos centerPos, int range, boolean halfX, boolean halfY, boolean halfZ) {
        return centerPos.offset((this.random.nextInt(range) - range / 2) / (halfX ? 2 : 1), (this.random.nextInt(range) - range / 2) / (halfY ? 2 : 1), (this.random.nextInt(range) - range / 2) / (halfZ ? 2 : 1));
    }

    private void unimplementedStain(Player player) {
        player.displayClientMessage((Component)Component.literal((String)"Used stain Recipe not yet implemented"), true);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 8;
    }
}

