/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.item.AbyssTechItems;

public class MortBlend
extends Item {
    private static final Map<Block, Block> TUNING_MAP = Map.of(Blocks.CALCITE, (Block)AbyssTechBlocks.MORT_MARBLE.get(), Blocks.DIORITE, (Block)AbyssTechBlocks.MORT_MARBLE.get());

    public MortBlend(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Block clickedBlock = level.getBlockState(pos).getBlock();
        if (!level.isClientSide() && TUNING_MAP.containsKey(clickedBlock)) {
            level.setBlockAndUpdate(context.getClickedPos(), TUNING_MAP.get(clickedBlock).defaultBlockState());
            context.getItemInHand().shrink(1);
            level.playSound(null, context.getClickedPos(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS);
            ((ServerLevel)level).sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, AbyssTechItems.MORT_BLEND.toStack()), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.8f), (double)((float)pos.getZ() + 0.5f), 12, 0.5, 0.5, 0.5, (double)0.05f);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_blend.tooltip.1"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_blend.tooltip.2"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

