/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.particle.AbyssTechParticles;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechAttachmentType;
import net.quasar.abysstech.util.AbyssTechTags;
import net.quasar.abysstech.util.AbyssTechUtility;

public class MortKnife
extends Item {
    Random random = new Random();

    public MortKnife(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        Level level = player.level();
        BlockPos pos = player.blockPosition();
        if (!level.isClientSide() && interactionTarget.getType() == EntityType.COW) {
            interactionTarget.hurt(player.damageSources().playerAttack(player), 20.0f);
            for (int i = 0; i < Math.max(this.random.nextInt(3), 1); ++i) {
                AbyssTechUtility.ItemSimpleSpawn(level, interactionTarget.blockPosition(), Items.LEATHER);
            }
            AbyssTechUtility.SimpleDamageHeldItem(level, pos, player, AbyssTechItems.MORT_KNIFE.asItem());
            level.playSound(null, pos, AbyssTechSounds.SKIN.get(), SoundSource.BLOCKS);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        BlockState blockToTest = level.getBlockState(pos);
        if (player != null) {
            if (!level.isClientSide()) {
                if (player.isShiftKeyDown()) {
                    if (blockToTest.is(AbyssTechTags.Blocks.CAN_USE_ABYSS_ESSENCE)) {
                        AbyssTechUtility.DrawPathToEssence(level, pos, 6, blockToTest);
                        level.playSound(null, pos, AbyssTechSounds.KNIFE_HIT.get(), SoundSource.BLOCKS);
                    } else if (blockToTest.is(AbyssTechBlocks.REFLECTOR_LIVELY)) {
                        this.useOnReflector(level, pos, AbyssTechParticles.LIVELY_BEAM_PARTICLES.get());
                    } else if (blockToTest.is(AbyssTechBlocks.REFLECTOR_VIBRANT)) {
                        this.useOnReflector(level, pos, AbyssTechParticles.VIBRANT_BEAM_PARTICLES.get());
                    }
                }
            } else if (blockToTest.is(AbyssTechBlocks.MIXER_BASE)) {
                player.setData(AbyssTechAttachmentType.TOGGLE_ECHO_RENDER, (Object)((Boolean)player.getData(AbyssTechAttachmentType.TOGGLE_ECHO_RENDER) == false ? 1 : 0));
                level.playSound(player, pos, AbyssTechSounds.KNIFE_HIT.get(), SoundSource.BLOCKS);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void useOnReflector(Level level, BlockPos pos, SimpleParticleType particleType) {
        BlockPos[] direction = new BlockPos[]{pos.north(2), pos.east(2), pos.south(2), pos.west(2), pos.above(2), pos.below(2)};
        for (int i = 0; i < 6; ++i) {
            if (!level.getBlockState(direction[i]).is(AbyssTechTags.Blocks.USES_REFLECTOR)) continue;
            AbyssTechUtility.drawPathToTarget(level, pos, direction[i], 0.05f, particleType);
        }
        level.playSound(null, pos, AbyssTechSounds.KNIFE_HIT.get(), SoundSource.BLOCKS);
    }

    public boolean hasCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.getDamageValue() < itemStack.getMaxDamage() - 1;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack stack = itemStack.copy();
        stack.setDamageValue(stack.getDamageValue() + 1);
        return stack;
    }
}

