/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.item.custom;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.quasar.abysstech.block.AbyssTechBlocks;
import net.quasar.abysstech.block.custom.AbyssMirror;
import net.quasar.abysstech.block.custom.EssenceFunnel;
import net.quasar.abysstech.block.custom.MagGlass;
import net.quasar.abysstech.component.AbyssTechDataComponentTypes;
import net.quasar.abysstech.item.AbyssTechItems;
import net.quasar.abysstech.sound.AbyssTechSounds;
import net.quasar.abysstech.util.AbyssTechUtility;

public class MortTuningWand
extends Item {
    private static final Map<Block, Block> TUNING_MAP = Map.of((Block)AbyssTechBlocks.PILLAR_UNTUNED.get(), (Block)AbyssTechBlocks.PILLAR_COALESCING.get(), (Block)AbyssTechBlocks.PILLAR_COALESCING.get(), (Block)AbyssTechBlocks.PILLAR_CONDUCTING.get(), (Block)AbyssTechBlocks.PILLAR_CONDUCTING.get(), (Block)AbyssTechBlocks.PILLAR_COALESCING.get());

    public MortTuningWand(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState clickedState = level.getBlockState(pos);
        Block clickedBlock = clickedState.getBlock();
        if (!level.isClientSide() && context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            if (TUNING_MAP.containsKey(clickedBlock)) {
                Block ValidBlock = (Block)AbyssTechBlocks.PILLAR_UNTUNED.get();
                BlockState CheckAbove = level.getBlockState(context.getClickedPos().above(1));
                BlockState CheckBelow = level.getBlockState(context.getClickedPos().below(1));
                if (CheckAbove.getBlock() == ValidBlock && CheckBelow.getBlock() == ValidBlock) {
                    level.setBlockAndUpdate(context.getClickedPos(), TUNING_MAP.get(clickedBlock).defaultBlockState());
                    AbyssTechUtility.SimpleDamageHeldItem(level, pos, context.getPlayer(), AbyssTechItems.MORT_TUNING_WAND.asItem());
                    context.getLevel().playSound(null, context.getClickedPos(), AbyssTechSounds.MAGIC_CARVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else if (clickedBlock == AbyssTechBlocks.ABYSS_MIRROR.get()) {
                if (!((Boolean)level.getBlockState(context.getClickedPos()).getValue((Property)AbyssMirror.mirrorReady)).booleanValue()) {
                    if (context.getItemInHand().get(AbyssTechDataComponentTypes.BLOCK_LOCATION) == null) {
                        context.getItemInHand().set((DataComponentType)AbyssTechDataComponentTypes.BLOCK_LOCATION.get(), (Object)context.getClickedPos());
                        level.setBlockAndUpdate(context.getClickedPos(), (BlockState)level.getBlockState(context.getClickedPos()).setValue((Property)AbyssMirror.mirrorReady, (Comparable)Boolean.valueOf(true)));
                        level.playSound(null, context.getClickedPos(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        BlockEntity mirrorBlockEntity = level.getBlockEntity(context.getClickedPos());
                        mirrorBlockEntity.getPersistentData().putInt("tar_x", ((BlockPos)context.getItemInHand().get(AbyssTechDataComponentTypes.BLOCK_LOCATION)).getX());
                        mirrorBlockEntity.getPersistentData().putInt("tar_y", ((BlockPos)context.getItemInHand().get(AbyssTechDataComponentTypes.BLOCK_LOCATION)).getY());
                        mirrorBlockEntity.getPersistentData().putInt("tar_z", ((BlockPos)context.getItemInHand().get(AbyssTechDataComponentTypes.BLOCK_LOCATION)).getZ());
                        level.setBlockAndUpdate(context.getClickedPos(), (BlockState)level.getBlockState(context.getClickedPos()).setValue((Property)AbyssMirror.mirrorReady, (Comparable)Boolean.valueOf(true)));
                        context.getItemInHand().set((DataComponentType)AbyssTechDataComponentTypes.BLOCK_LOCATION.get(), null);
                        level.playSound(null, context.getClickedPos(), AbyssTechSounds.MIRROR_TUNE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else {
                this.iterateSwitchableFaces(level, clickedState, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void iterateSwitchableFaces(Level level, BlockState clickedState, BlockPos clickedPos) {
        Block[] validSwitchable = new Block[]{(Block)AbyssTechBlocks.ESSENCE_FUNNEL.get(), (Block)AbyssTechBlocks.MAGNIFYING_GLASS.get()};
        DirectionProperty[] validFacingStates = new DirectionProperty[]{EssenceFunnel.FACING, MagGlass.FACING};
        for (int i = 0; i < validSwitchable.length; ++i) {
            this.switchFace(level, clickedState, clickedPos, validSwitchable[i], validFacingStates[i]);
        }
    }

    private void switchFace(Level level, BlockState clickedState, BlockPos clickedPos, Block testFor, DirectionProperty dirProp) {
        if (clickedState.is(testFor)) {
            Direction stateNew = switch ((Direction)clickedState.getValue((Property)dirProp)) {
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.UP;
                case Direction.UP -> Direction.DOWN;
                default -> Direction.NORTH;
            };
            level.setBlockAndUpdate(clickedPos, (BlockState)clickedState.setValue((Property)dirProp, (Comparable)stateNew));
            level.playSound(null, clickedPos, AbyssTechSounds.WRENCH.get(), SoundSource.BLOCKS, 1.0f, 2.0f);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_tuning_wand.tooltip.1"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_tuning_wand.tooltip.2"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_tuning_wand.tooltip.3"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_tuning_wand.tooltip.4"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_tuning_wand.tooltip.5"));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.abysstech.mort_tuning_wand.tooltip.6"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

