/*
 * Decompiled with CFR 0.152.
 */
package net.quasar.abysstech.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class EssenceParticles
extends TextureSheetParticle {
    private float pSize = 1.0f;
    private int age = 0;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float rotZ = 0.0f;

    protected EssenceParticles(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 1.0f;
        this.lifetime = 80;
        this.setParticleSpeed(0.0, 0.0, 0.0);
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        this.pSize = this.age > 10 ? this.pSize - 0.018f : this.pSize + 0.012f;
        this.scale(this.pSize);
        this.rotY += 0.15f;
        this.rotX += 0.15f;
        this.rotZ += 0.15f;
        ++this.age;
        super.tick();
    }

    public void render(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotationYXZ(this.rotY, this.rotX, this.rotZ);
        for (int i = 0; i < 6; ++i) {
            switch (i) {
                case 1: {
                    quaternion.rotateY((float)Math.PI);
                    break;
                }
                case 2: {
                    quaternion.rotationYXZ(this.rotY + 1.5707964f, this.rotX, this.rotZ);
                    break;
                }
                case 3: {
                    quaternion.rotationYXZ(this.rotY - 1.5707964f, this.rotX, this.rotZ);
                    break;
                }
                case 4: {
                    quaternion.rotationYXZ(this.rotY, this.rotX + 1.5707964f, this.rotZ);
                    break;
                }
                case 5: {
                    quaternion.rotationYXZ(this.rotY, this.rotX - 1.5707964f, this.rotZ);
                }
            }
            this.renderRotatedQuad(buffer, renderInfo, quaternion, partialTicks);
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public int getLightColor(float partialTick) {
        return 240;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType simpleParticleType, ClientLevel clientLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new EssenceParticles(clientLevel, pX, pY, pZ, this.spriteSet, pXSpeed, pYSpeed, pZSpeed);
        }
    }
}

